//---------------------------------------------------------------------------
#ifndef wykr3dH
#define wykr3dH
#include "3d.h"
//---------------------------------------------------------------------------
//	Wykres pachty funkcyjnej z pen projekcj 3d i
//	punktem owietlajcym.
class TWykres3d : private T3d               //elementy obiektu T3d bd prywatne
{
 private:
    int i, j;                               //zmienne robocze iteratora
    int fil_x, fil_y;                       //liczba podziaw
    double xstart, xkoniec, dx;             //granice i krok podziau w poziomie
    double ystart, ykoniec, dy;             //granice i krok podziau w pionie
    double vxosw, vyosw, vzosw;             //unormowany wektor wskazujcy punkt owietlenia
 public:
    TWykres3d( TPunkt obs,                  //pozycja obserwatora
        TPunkt osw,                         //pozycja punktu owietlajcego
        double xr0, double yr0, double rszer, double rwys,//obszar funkcji
        int il_x, int il_y,                     //dokadno krelenia - liczba podziaw dziedziny
        int xe0, int ye0, int eszer, int ewys,  //okno ekranowe
        double odl_ekr=0.5,
        double szer_ekr=0, double wys_ekr=0);   //fizyczny opis ekranu

    virtual double fun( double x, double y);    //funkcja do wyrysowania

    void inicjuj_iterator( void);               //pocztek krelenia
    bool iterator( int &xe1, int &ye1, int &xe2, int &ye2,	//krelenie element po elemencie, dopki true
        int &xe3, int &ye3, int &xe4, int &ye4, int &jasnosc);
};
#endif
