//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "3d.h"
#include "finterf3d_1.h"
#include "skala.h"
#include "math.h"
#include "widmo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//  Inicjowanie parametrw.
//  Wpisanie okrgego otworka w tablic P.
void __fastcall TForm1::FormShow(TObject *Sender)
{
 inicjuj_parametry();
                            //pojedynczy otworek na rodku
 int i, j, a = IL_PODZ / 2;

 for( i = 0; i < IL_PODZ; i ++)
    for( j = 0; j < IL_PODZ; j ++)
        P[ i][ j] = 0;      //nie ma dziurek

               P[a-1][a-2] = P[a][a-2] = P[a+1][a-2] = 1;
 P[a-2][a-1] = P[a-1][a-1] = P[a][a-1] = P[a+1][a-1] = P[a+2][a-1] = 1;
 P[a-2][a] = P[a-1][a] = P[a][a] = P[a+1][a] = P[a+2][a] = 1;
 P[a-2][a+1] = P[a-1][a+1] = P[a][a+1] = P[a+1][a+1] = P[a+2][a+1] = 1;
               P[a-1][a+2] = P[a][a+2] = P[a+1][a+2] = 1;
}
//---------------------------------------------------------------------------
//  Wyodrbniony algorytm sczytywania nastaw interfejsu.
void TForm1::inicjuj_parametry( void)
{
 try                        //spodziewamy si rnych bdw w danych
 {
    L = TrackBar1 -> Position * 1e-9;
    z_p=Edit1 -> Text.ToDouble();
    z_e=Edit3 -> Text.ToDouble();
    rozm_p=Edit2 -> Text.ToDouble();
    rozm_e=Edit4 -> Text.ToDouble();
    obs.x=Edit5 -> Text.ToDouble();
    obs.y=Edit6 -> Text.ToDouble();
    obs.z=Edit7 -> Text.ToDouble();
 }
 catch(...)                 //nie zmienione wartoci parametrw
 {
 }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 interferuj();

 T3d d3( obs, 0, 0, PaintBox1 -> Width, PaintBox1 -> Height);
 pokaz_ekran( d3);
 pokaz_przyslone( d3);
}
//---------------------------------------------------------------------------
//  Zbuduj obraz amplitud fal w tablicy E (ekran).
void TForm1 :: interferuj( void)
{
 int i, j, m, n;
 double x_p, y_p, x_e, y_e;     //bieca pozycja na przes. i ekr.
 double r;                      //odlego biecych pozycji przys. - ekr.
 double odl2 = (z_e - z_p) * (z_e - z_p);   //pomocnicze - kwadrat odlegoci przys.-ekr.
 double k = 2 * M_PI/L;         //pomocnicze - tzw. liczba falowa
 double suma_fal, max_suma_fal = 0;	//amplituda zoenia fal ze wszystkich otworkw
 TSkalowanie s_p( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, rozm_p, rozm_p);
 TSkalowanie s_e( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, rozm_e, rozm_e);

 for( i = 0; i < IL_PODZ; i++)
 {
    x_e = s_e.daj_real_x( i);
    for( j = 0; j < IL_PODZ; j++)
    {
        y_e = s_e.daj_real_y( j);
        suma_fal = 0.0;             //wane. Za chwil zbierzemy tutaj amplitudy
        for( m = 0; m < IL_PODZ; m++)
        {
            x_p = s_p.daj_real_x( m);
            for( n = 0; n < IL_PODZ; n++)
            {
                if( P[ n][ m]!=0)   //jest dziurka?
                {
                    y_p = s_p.daj_real_y( n);
                    r = sqrt((x_e-x_p) * (x_e-x_p) + (y_e-y_p) * (y_e-y_p) + odl2);
                    suma_fal += P[ n][ m] * sin( k*r);
                }
            }
        }
        E[ j][ i] = suma_fal;       //przechowanie wyliczonej amplitudy
        if( suma_fal < -max_suma_fal || suma_fal > max_suma_fal)
       	    max_suma_fal = suma_fal;    //wyapanie najwikszej amplitudy
    }
 }
 if( max_suma_fal != 0)
 {
    for( i = 0; i < IL_PODZ; i ++)      //zawarto tablicy unormuj do zakresu -1 ...+1
	    for( j = 0; j < IL_PODZ; j ++)
            E[ j][ i] = E[ j][ i] / max_suma_fal;
 }
}
//---------------------------------------------------------------------------
void TForm1 :: pokaz_przyslone( T3d d3)
{
 TSkalowanie s_p( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, rozm_p, rozm_p);
 int i, j;
 int xe, ye, jasn;                  //wsprzdne ekranowe i jasno elementu
 double x1, x2, y1, y2;             //wierzchoki elementarnego prostokta
 TPoint p[ 5];
 TColor kolor;

// PaintBox1 -> Canvas -> Pen -> Color = clSilver;   //kolor linii
 for( i = 0; i < IL_PODZ; i++)
 {
    x1 = s_p.daj_real_x( i);
    x2 = s_p.daj_real_x( i+1);
    for( j = 0; j < IL_PODZ; j++)
    {
        y1 = s_p.daj_real_y( j);
        y2 = s_p.daj_real_y( j+1);
        d3.punkt_3d( xe, ye, TPunkt( x1, y1, z_p));
        p[ 0].x = xe;               //opis elementarnego czworokcika
        p[ 0].y = ye;
        p[ 4].x = xe;               //"domknicie" konturu
        p[ 4].y = ye;
        d3.punkt_3d( xe, ye, TPunkt( x1, y2, z_p));
        p[ 1].x = xe;
        p[ 1].y = ye;
        d3.punkt_3d( xe, ye, TPunkt( x2, y2, z_p));
        p[ 2].x = xe;
        p[ 2].y = ye;
        d3.punkt_3d( xe, ye, TPunkt( x2, y1, z_p));
        p[ 3].x = xe;
        p[ 3].y = ye;
        jasn = P[i][j] * 255;       //uwaga: tablica jest unormowana!
        kolor = RGB( jasn, jasn, jasn);
        PaintBox1 -> Canvas -> Brush -> Color = kolor;
        PaintBox1 -> Canvas -> Pen -> Color = kolor;
        PaintBox1 -> Canvas -> Polygon( p, 4);
    }
 }
}
//---------------------------------------------------------------------------
void TForm1 :: pokaz_ekran( T3d d3)
{
 TSkalowanie s_e( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, rozm_e, rozm_e);
 TWidmo w;
 int i, j;
 int xe, ye, jasn;                  //wsprzdne ekranowe i jasno elementu
 double x1, x2, y1, y2;             //wierzchoki elementarnego prostokta
 TPoint p[ 5];
 TColor kolor;

// PaintBox1 -> Canvas -> Pen -> Color = clSilver;   //kolor linii
 for( i = 0; i < IL_PODZ; i++)
 {
    x1 = s_e.daj_real_x( i);
    x2 = s_e.daj_real_x( i+1);
    for( j = 0; j < IL_PODZ; j++)
    {
        y1 = s_e.daj_real_y( j);
        y2 = s_e.daj_real_y( j+1);
        d3.punkt_3d( xe, ye, TPunkt( x1, y1, z_e));
        p[ 0].x = xe;               //opis elementarnego czworokcika
        p[ 0].y = ye;
        p[ 4].x = xe;               //"domknicie" konturu
        p[ 4].y = ye;
        d3.punkt_3d( xe, ye, TPunkt( x1, y2, z_e));
        p[ 1].x = xe;
        p[ 1].y = ye;
        d3.punkt_3d( xe, ye, TPunkt( x2, y2, z_e));
        p[ 2].x = xe;
        p[ 2].y = ye;
        d3.punkt_3d( xe, ye, TPunkt( x2, y1, z_e));
        p[ 3].x = xe;
        p[ 3].y = ye;
        jasn = E[i][j] * E[i][j] * 100; //uwaga: tablica E jest unormowana!
        kolor = w.lambda_to_kolor( jasn, L);
        PaintBox1 -> Canvas -> Brush -> Color = kolor;
        PaintBox1 -> Canvas -> Pen -> Color = kolor;
        PaintBox1 -> Canvas -> Polygon( p, 4);
    }
 }
}
//---------------------------------------------------------------------------
//  Rysowanie
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 inicjuj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
//  Koniec
void __fastcall TForm1::Button3Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------

