//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "finterferencja.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int marg = 10;
 TPunkt obserwator( 2000., 2000., 1100.);//pozycja obserwatora
 TPunkt oswietlenie( -5., 10., 0.); //pozycja punktu owietlajcego
 TWykres w3d( obserwator, oswietlenie,
    0., 0., 800., 800.,             //obszar funkcji
    400, 400,                       //dokadno krelenia
    marg, marg,
    ClientWidth - 2 * marg, ClientHeight - 2 * marg);//okno ekranowe
 int xe1, ye1, xe2, ye2, xe3, ye3, xe4, ye4, jasn;
 int a;
 TPoint p[ 5];
 TColor kolor;

 w3d.inicjuj_iterator();            //pocztek krelenia
 while( w3d.iterator( xe1, ye1, xe2, ye2, xe3, ye3, xe4, ye4, jasn))
 {
  p[ 0].x = xe1;                    //opis elementarnego czworokcika
  p[ 0].y = ye1;

  p[ 1].x = xe2;
  p[ 1].y = ye2;

  p[ 2].x = xe3;
  p[ 2].y = ye3;

  p[ 3].x = xe4;
  p[ 3].y = ye4;

  p[ 4].x = xe1;
  p[ 4].y = ye1;

  a = (int)((double)jasn * 2.5);    //pomocnicze
  kolor = (TColor)RGB( a, a, a);    //synteza koloru z amplitud RGB - tutaj szaro
  Canvas -> Pen -> Color = kolor;   //kolor linii
  Canvas -> Brush -> Color = kolor; //kolor wypenienia czworokcika
  Canvas -> Polygon( p, 4);
 }
}
//---------------------------------------------------------------------------
//  Konstruktor obiektu krelcego
TWykres :: TWykres(
    TPunkt obserwator,                      //pozycja obserwatora
    TPunkt oswietlenie,                     //pozycja punktu owietlajcego
    double xr0, double yr0, double rszer, double rwys,//obszar funkcji
    int il_x, int il_y,                     //dokadno krelenia - liczba podziaw dziedziny
    int xe0, int ye0, int eszer, int ewys)  //okno ekranowe
	: TWykres3d( obserwator, oswietlenie,
                xr0, yr0, rszer, rwys,
                il_x, il_y, xe0, ye0, eszer, ewys)
{
}
//---------------------------------------------------------------------------
//  Dwie fale koliste wygasajce wykadniczo.
//double TWykres :: fun( double x, double y)
//{
// double L = 4.0, d = 10.0;      // dugo fali i odl. rde
// double k, r, r1, r2;
//
// r = sqrt( x*x+y*y);            //odlego od punktu midzy rdami
// r1 = sqrt((x-d/2)*(x-d/2)+y*y);//odlego od pierwszego rda ...
// r2 = sqrt((x+d/2)*(x+d/2)+y*y);// .. i od drugiego
// k = 0.5 * M_PI / L;
//
// return 2*exp(-r/100.0)*( cos(k*r1) + cos(k*r2)); //warto funkcji
//}
//---------------------------------------------------------------------------
//  Wiele rde
double TWykres :: fun( double x, double y)
{
 double A, L = 4.0, d = 10.0, k;
 double r, r1, r2, r3, r4, r5, r6;

 r  = sqrt( x * x + y * y);
 r1 = sqrt((x - 4 * d) * (x - 4 * d) + y * y);
 r2 = sqrt((x - 2 * d) * (x - 2 * d) + y * y);
 r3 = sqrt((x - d) * (x - d) + y * y);
 r4 = sqrt((x + d) * (x + d) + y * y);
 r5 = sqrt((x + 2 * d) * (x + 2 * d) + y * y);
 r6 = sqrt((x + 4 * d) * (x + 4 * d) + y * y);
 A  = exp( -r / 200.0);
 k = 0.5 * M_PI / L;
 return A*(cos(k*r1)+cos(k*r2)+cos(k*r3)+
           cos(k*r4)+cos(k*r5)+cos(k*r6));
}
//---------------------------------------------------------------------------
