//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ffala_kolista_2.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner): TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int marg = 10;
 TPunkt obserwator( 100, 100, 50);  //pozycja obserwatora
 TPunkt oswietlenie( -5, 10, 0);    //pozycja punktu owietlajcego
 TWykres w3d( obserwator, oswietlenie,
    0., 0., 50., 50.,               //obszar funkcji
    80, 80,                         //dokadno krelenia
    marg, marg,
    ClientWidth - 2 * marg, ClientHeight - 2 * marg);//okno ekranowe
 int xe1, ye1, xe2, ye2, xe3, ye3, xe4, ye4, jasn;
 int a;
 TPoint p[ 5];
 TColor kolor;

 w3d.inicjuj_iterator();            //pocztek krelenia
 while( w3d.iterator( xe1, ye1, xe2, ye2, xe3, ye3, xe4, ye4, jasn))
 {
  p[ 0].x = xe1;                    //opis elementarnego czworokcika
  p[ 0].y = ye1;

  p[ 1].x = xe2;
  p[ 1].y = ye2;

  p[ 2].x = xe3;
  p[ 2].y = ye3;

  p[ 3].x = xe4;
  p[ 3].y = ye4;

  p[ 4].x = xe1;
  p[ 4].y = ye1;

  a = (int)((double)jasn * 2.5);    //pomocnicze
  kolor = (TColor)RGB( a, a, a);    //synteza koloru z amplitud RGB - tutaj szaro
  Canvas -> Pen -> Color = kolor;   //kolor linii
  Canvas -> Brush -> Color = kolor; //kolor wypenienia czworokcika
  Canvas -> Polygon( p, 4);
 }
}
//---------------------------------------------------------------------------
//  Konstruktor obiektu krelcego
TWykres :: TWykres(
    TPunkt obs,                             //pozycja obserwatora
    TPunkt osw,                             //pozycja punktu owietlajcego
    double xr0, double yr0, double rszer, double rwys,//obszar funkcji
    int il_x, int il_y,                     //dokadno krelenia - liczba podziaw dziedziny
    int xe0, int ye0, int eszer, int ewys)  //okno ekranowe
	: TWykres3d( obs, osw,
                xr0, yr0, rszer, rwys,
                il_x, il_y, xe0, ye0, eszer, ewys)
{
}
//---------------------------------------------------------------------------
//	Przedefiniowana funkcja obiektu podstawowego
//  Fala kolista wygasajca wykadniczo.
double TWykres :: fun( double x, double y)
{
 double r = sqrt(x * x + y * y);

 return 3.0 * exp( -r * 0.1) * cos( r);
}
//---------------------------------------------------------------------------
