//---------------------------------------------------------------------------
//	Biorytmy
//
#include <vcl\vcl.h>
#pragma hdrstop

#include "diagram.h"                //Obiekt TDiagram
#include "fbiorytm_2.h"
#include "math.h"                   //Funkcja sin()
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//  Konstruktor
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//  Przeksztacenie daty urodzenia w liczb dni ycia.
//  Odczytanie zakresu modelowania biorytmu
void TForm1 ::  inicjuj_parametry( void)
{
 int d = Edit1 -> Text.ToInt();
 int m = Edit2 -> Text.ToInt();
 int r = Edit3 -> Text.ToInt();
 TDateTime data_urodzenia( (unsigned short)r, (unsigned short)m, (unsigned short)d);

 il_dni_zycia = TDateTime().CurrentDate().Val - data_urodzenia.Val;
 zakres = Edit4 -> Text.ToInt() * 7;
}
//---------------------------------------------------------------------------
//  Funkcja odpowiedzialna za grafik okienka
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 inicjuj_parametry();               //liczba dni ycia, zakres
 TDiagram d( 32, 70, 360, 140,
    il_dni_zycia, 0.0, 2.0 * zakres, 6.0, Canvas);

 kresl_sume_bio_linii( d);
 d.siatka( 7, 1.0);                 //Dodatkowa kosmetyka wykresu
}
//---------------------------------------------------------------------------
//  Wykrelenie sumy 3 sinusoid
void TForm1 :: kresl_sume_bio_linii( TDiagram diag)
{

 int xe_old, ye_old, xe, ye;        //punkt poprzedni i biecy - do odcinka linii wykresu
 bool pierwszy_punkt = true;        //pierwszy odcinek wykresu nie ma punktu poprzedniego
 TColor kolor = clBlue;

 Canvas -> Pen -> Color = kolor;
 Canvas -> Pen -> Width = 2;
 for( double nr = il_dni_zycia - zakres; nr <= il_dni_zycia + zakres; nr ++)
 {
    xe = diag.daj_ekr_x( nr);
    ye = diag.daj_ekr_y( daj_bio_wartosc( nr));
    if( pierwszy_punkt)             //Pocztek wykresu? Bez linii
    {
        Canvas -> Pixels[ xe][ ye] = kolor;
        pierwszy_punkt = false;
    }
    else                            //Kontynuacja linii wykresu
    {
        Canvas -> MoveTo( xe_old, ye_old);
        Canvas -> LineTo( xe, ye);
    }

    xe_old = xe;
    ye_old = ye;
 }
 Canvas -> Pen -> Width = 1;
}
//---------------------------------------------------------------------------
//	Warto sumy 3 sinusoid w 'nr' dniu ycia.
//	Funkcja ma minimum (=-1) dla dnia nr=0.
//	Staa M_PI jest zdefiniowana w pliku math.h
double TForm1 :: daj_bio_wartosc( double nr)
{
 double k = 2. * M_PI * nr, f = M_PI / 2.;
 return sin( k / 23.0 - f) + sin( k / 28.0 - f) + sin( k / 33.0 - f);
}
//---------------------------------------------------------------------------
//	Nacinicie przycisku 'Rysuj'
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 Refresh();
}
//---------------------------------------------------------------------------
