//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "diagram.h"
//---------------------------------------------------------------------------
//	Konstruktor najpierw uruchamia konstruktora klasy bazowej,
//	przekazujc mu cz parametrw.
// Przechwytuje do wewntrznych zmiennych wskanik do aparatu graficznego
// i rozmiar teatru matematycznego, by kreli domylne ukady odniesienia.
TDiagram :: TDiagram( int xe0, int ye0, int eszer, int ewys,
           double Axr0, double Ayr0, double Arszer, double Arwys,
           TCanvas *Acanvas) :
           TSkalowanie( xe0, ye0, eszer, ewys, Axr0, Ayr0, Arszer, Arwys)
{
 canvas = Acanvas;
 xr0 = Axr0;
 yr0 = Ayr0;
 rszer = Arszer;
 rwys = Arwys;
}
//---------------------------------------------------------------------------
//	Siatka wsprzdnych. Kreslenie podziaki rozpoczynamy odrodka
// na lewo i prawo i potem w d i w gr powek osi.
//	(x0, y0) - rodek ukadu wsprzdnych
//	(x1 - x2) - rozpito w osi X
//	(y1 - y2) - rozpito w osi Y
//	dx, dy - rozmiary oczka siatki
// kolor - kolor grafiki
void TDiagram :: siatka( double x0, double y0,
             double x1, double x2,
             double y1, double y2,
             double dx, double dy,
             TColor kolor/*=clGray*/)
{
 double x, y;
 int xe, ye, xemin, xemax, yemin, yemax;
 TColor curr_kolor = canvas -> Pen -> Color;
 canvas -> Pen -> Color = kolor;

 xemin = daj_ekr_x( x1);	//rogi siatki na ekranie
 xemax = daj_ekr_x( x2);
 yemin = daj_ekr_y( y1);
 yemax = daj_ekr_y( y2);

 for( x = x0; x >= x1; x -= dx)		//cz lewa podziaki osi poziomej
 {
 	xe = daj_ekr_x( x);
   canvas -> MoveTo( xe, yemin);
   canvas -> LineTo( xe, yemax);
 }

 for( x = x0; x <= x2; x += dx)		//cz prawa podziaki osi poziomej
 {
 	xe = daj_ekr_x( x);
   canvas -> MoveTo( xe, yemin);
   canvas -> LineTo( xe, yemax);
 }

 for( y = y0; y >= y1; y -= dy)		//cz dolna podziaki osi pionowej
 {
 	ye = daj_ekr_y( y);
   canvas -> MoveTo( xemin, ye);
   canvas -> LineTo( xemax, ye);
 }

 for( y = y0; y <= y2; y += dy)		//cz grna podziaka osi pionowej
 {
 	ye = daj_ekr_y( y);
   canvas -> MoveTo( xemin, ye);
   canvas -> LineTo( xemax, ye);
 }
 canvas -> Pen -> Color = curr_kolor;
}
//---------------------------------------------------------------------------
//	Uproszczona siatka wsprzdnych - domyla si rozmiaru osi.
//	(x0, y0) - rodek ukadu wsprzdnych
//	dx, dy - rozmiary oczka siatki
// kolor - kolor grafiki
void TDiagram :: siatka( double x0, double y0,
             double dx, double dy,
             TColor kolor/*=clGray*/)
{
 siatka( x0, y0,
         xr0 - rszer / 2, xr0 + rszer / 2,
         yr0 - rwys / 2, yr0 + rwys / 2,
         dx, dy, kolor);
}
//---------------------------------------------------------------------------
//	Jeszcze bardziej uproszczona siatka wsprzdnych -
//  domyla si rozmiaru osi i punktu zaczepienia ukadu wsprzdnych.
//	dx, dy - rozmiary oczka siatki
// kolor - kolor grafiki
void TDiagram :: siatka( double dx, double dy, TColor kolor/*=clGray*/)
{
 siatka( xr0 - rszer / 2, yr0 - rwys / 2, dx, dy, kolor);
}
//---------------------------------------------------------------------------
//	Ukad wsprzdnych. Kreslenie podziaki rozpoczynamy odrodka
// na lewo i prawo i potem w d i w gr powek osi.
//	(x0, y0) - rodek ukadu wsprzdnych
//	(x1 - x2) - rozpito osi X
//	(y1 - y2) - rozpito osi Y
//	dx, dy - skok podziaek
//	delta - rozmiar kreski podziaki w pikselach
// kolor - kolor grafiki
void TDiagram :: uklad_xy( double x0, double y0,
             double x1, double x2,
             double y1, double y2,
             double dx, double dy,
             int delta, TColor kolor/*=clGray*/)
{
 double x, y;
 int xe0, ye0, xe, ye, xemin, xemax, yemin, yemax;
 int d = delta / 2;

 TColor curr_kolor = canvas -> Pen -> Color;
 canvas -> Pen -> Color = kolor;

 xe0 = daj_ekr_x( x0);		//rodek ukadu wsprzdnych
 ye0 = daj_ekr_y( y0);

 xemin = daj_ekr_x( x1);	//rozpitoci osi ukadu
 xemax = daj_ekr_x( x2);
 yemin = daj_ekr_y( y1);
 yemax = daj_ekr_y( y2);

 canvas -> MoveTo( xemin, ye0);		//o pozioma
 canvas -> LineTo( xemax, ye0);
 for( x = x0; x >= x1; x -= dx)		//cz lewa podziaki osi poziomej
 {
 	xe = daj_ekr_x( x);
   canvas -> MoveTo( xe, ye0 - d);
   canvas -> LineTo( xe, ye0 + d);
 }

 for( x = x0; x <= x2; x += dx)		//cz prawa podziaki osi poziomej
 {
 	xe = daj_ekr_x( x);
   canvas -> MoveTo( xe, ye0 - d);
   canvas -> LineTo( xe, ye0 + d);
 }

 canvas -> MoveTo( xe0, yemin);		//o pionowa
 canvas -> LineTo( xe0, yemax);
 for( y = y0; y >= y1; y -= dy)		//cz dolna podziaki osi pionowej
 {
 	ye = daj_ekr_y( y);
   canvas -> MoveTo( xe0 - d, ye);
   canvas -> LineTo( xe0 + d, ye);
 }

 for( y = y0; y <= y2; y += dy)		//cz grna podziaka osi pionowej
 {
 	ye = daj_ekr_y( y);
   canvas -> MoveTo( xe0 - d, ye);
   canvas -> LineTo( xe0 + d, ye);
 }
 canvas -> Pen -> Color = curr_kolor;
}
//---------------------------------------------------------------------------
//	Uproszczony ukad xy - domyla si rozmiaru osi.
//	(x0, y0) - rodek ukadu wsprzdnych
//	dx, dy - rozmiary oczka siatki
// delta - rozmiar kreski podziaki
// kolor - kolor grafiki
void TDiagram :: uklad_xy( double x0, double y0,
             double dx, double dy,
             int delta, TColor kolor/*=clGray*/)
{
 uklad_xy( x0, y0,
         xr0 - rszer / 2, xr0 + rszer / 2,
         yr0 - rwys / 2, yr0 + rwys / 2,
         dx, dy, delta, kolor);
}
//---------------------------------------------------------------------------
//	Jeszcze bardziej uproszczony ukad xy -
// domyla si rozmiaru osi i punktu zaczepienia ukadu wsprzdnych.
//	(x0, y0) - rodek ukadu wsprzdnych
//	dx, dy - rozmiary oczka siatki
// delta - rozmiar kreski podziaki
// kolor - kolor grafiki
void TDiagram :: uklad_xy( double dx, double dy,
              int delta, TColor kolor/*=clGray*/)
{
 uklad_xy( xr0 - rszer / 2, yr0 - rwys / 2, dx, dy, delta, kolor);
}
//---------------------------------------------------------------------------
// Napis w miejscu (x, y)
void TDiagram :: napis( double x, double y, AnsiString tekst)
{
 canvas -> TextOut( daj_ekr_x( x), daj_ekr_y( y), tekst);
}
//---------------------------------------------------------------------------
// Punkt w miejscu (x, y). Rozmiar = delta.
// Typy - P_Kolo, P_Kwadrat, P_Krzyz, inne Twoje typy?
void TDiagram :: punkt( double x, double y, int delta,
              TypPunktu typ/*=P_Kolo*/, TColor kolor/*=clGray*/)
{
 int xe = daj_ekr_x( x), ye = daj_ekr_y( y);
 int d = delta / 2;
 TColor curr_pen_kolor = canvas -> Pen -> Color;
 TColor curr_brush_kolor = canvas -> Brush -> Color;
 canvas -> Pen -> Color = kolor;
 canvas -> Brush -> Color = kolor;

 switch( typ)
 {
  case P_Kolo:
  				canvas -> Ellipse( xe-d, ye-d, xe+d, ye+d);
               break;
  case P_Kwadrat:
  				canvas -> Rectangle( xe-d, ye-d, xe+d, ye+d);
               break;
  case P_Krzyz:
  				canvas -> MoveTo( xe-d, ye);
               canvas -> LineTo( xe+d, ye);
  				canvas -> MoveTo( xe, ye-d);
               canvas -> LineTo( xe, ye+d);
               break;
 }
 canvas -> Pen -> Color = curr_pen_kolor;
 canvas -> Brush -> Color = curr_brush_kolor;
}

