//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ftech1.h"
#include "math.h"
#include "3d.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
 inicjuj_parametry();
}
//---------------------------------------------------------------------------
void TForm1::inicjuj_parametry( void)
{
 Pobs = TPunkt( TrackBar1 -> Position, TrackBar2 -> Position, TrackBar3 -> Position);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 inicjuj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 double odl_ekr = 4., d2 = 0.01;     //odlego i rozmiar powki okna
 T3d d( Pobs, 0, 0, PaintBox1 -> Width, PaintBox1 -> Height,
        odl_ekr);
// TSkalowanie s( 0, 0, PaintBox1 -> Width, PaintBox1 -> Height,
//        d/2, d/2, d, d);

// double min_i = s.daj_real_x( 0),   //rozpito ekranu w Real
//        min_j = s.daj_real_y( PaintBox1 -> Height),
//        max_i = s.daj_real_x( PaintBox1 -> Width),
//        max_j = s.daj_real_y( 0);
 double min_i = d2, min_j = d2, max_i = d2, max_j = d2;

 double Rxy = sqrt( Pobs.x * Pobs.x + Pobs.y * Pobs.y);
 double R = sqrt( Rxy * Rxy + Pobs.z * Pobs.z);

 double x0 = Pobs.x * (R - odl_ekr) / R, //rodek ekranu w Real
        y0 = Pobs.y * (R - odl_ekr) / R,
        z0 = Pobs.z * (R - odl_ekr) / R;
 double x, y, z;

 z = z0 + max_j * Rxy / R;
 x = (x0 - max_j * Pobs.z / R) + min_i * Pobs.y / Rxy;
 y = (y0 - max_j * Pobs.z / R) - min_i * Pobs.x / Rxy;
 TPunkt p1( x, y, z);

 z = z0 + max_j * Rxy / R;
 x = (x0 - max_j * Pobs.z / R) - max_i * Pobs.y / Rxy;
 y = (y0 - max_j * Pobs.z / R) + max_i * Pobs.x / Rxy;
 TPunkt p2( x, y, z);

 z = z0 - min_j * Rxy / R;
 x = (x0 + min_j * Pobs.z / R) - max_i * Pobs.y / Rxy;
 y = (y0 + min_j * Pobs.z / R) + max_i * Pobs.x / Rxy;
 TPunkt p3( x, y, z);

 z = z0 - min_j * Rxy / R;
 x = (x0 + max_j * Pobs.z / R) + max_i * Pobs.y / Rxy;
 y = (y0 + max_j * Pobs.z / R) - max_i * Pobs.x / Rxy;
 TPunkt p4( x, y, z);

 int xe0, ye0, xe, ye;

 TPunkt p0( x0, y0, z0);
 d.punkt_3d( xe0, ye0, p0);
 PaintBox1 -> Canvas -> Pixels[ xe0][ye0] = clBlack;

 d.punkt_3d( xe0, ye0, p1);
 PaintBox1 -> Canvas -> MoveTo( xe0, ye0);

 d.punkt_3d( xe, ye, p2);
 PaintBox1 -> Canvas -> LineTo( xe, ye);

 d.punkt_3d( xe, ye, p3);
 PaintBox1 -> Canvas -> LineTo( xe, ye);

 d.punkt_3d( xe, ye, p4);
 PaintBox1 -> Canvas -> LineTo( xe, ye);

 PaintBox1 -> Canvas -> LineTo( xe0, ye0);
}
//---------------------------------------------------------------------------
