//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
//  Konstruktor podstawowy
TTrojkat :: TTrojkat( TPunkt Ap1, TPunkt Ap2, TPunkt Ap3)
{
 p1 = Ap1;
 p2 = Ap2;
 p3 = Ap3;
 N = iloczyn_wektorowy( TWektor( p2, p1), TWektor( p3, p1));
 N.unormuj();
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TTrojkat :: TTrojkat( const TTrojkat &t)
{
 p1 = t.p1;
 p2 = t.p2;
 p3 = t.p3;
 N = t.N;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TTrojkat & TTrojkat :: operator= (const TTrojkat &t)
{
 if( this != &t)
 {
    p1 = t.p1;
    p2 = t.p2;
    p3 = t.p3;
    N = t.N;
 }
 return *this;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor domylny
TPromien :: TPromien( void)
{
 r0 = TPunkt();
 kierunek = TWektor();
}
//---------------------------------------------------------------------------
//  Konstruktor podstawowy. Promien z punktu Ar0, skierowany w Akierunek
TPromien :: TPromien( TPunkt Ar0, TWektor Akierunek)
{
 r0 = Ar0;
 kierunek = Akierunek;
}
//---------------------------------------------------------------------------
//  Inny konstruktor. Promien skierowany od a do b.
TPromien :: TPromien( TPunkt Aa, TPunkt Ab)
{
 r0 = Aa;
 kierunek = TWektor( Ab.x - Aa.x, Ab.y - Aa.y, Ab.z - Aa.z);
 kierunek.unormuj();
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TPromien :: TPromien( const TPromien &p)
{
 r0 = p.r0;
 kierunek = p.kierunek;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TPromien & TPromien :: operator= (const TPromien &p)
{
 if( this != &p)
 {
    r0 = p.r0;
    kierunek = p.kierunek;
 }
 return *this;
}
//---------------------------------------------------------------------------
//  Wyznaczenie punktu przecicia promienia z paszczyzn trjkta.
//  Za chwil wyznaczymy, czy punkt ten ley wewntrz trjkta,
//  tzn, czy promie trafia w trjkt.
//  Parametry referencyjne s wypeniane, o ile przecicie istnieje.
bool TPromien :: czy_trafia_w_plaszczyzne( TTrojkat t, TPunkt &p)
{
 double D = -(t.N.x * t.p1.x +
              t.N.y * t.p1.y +
              t.N.z * t.p1.z);      //wspczynnik D r-nia paszczyzny Ax+By+Cz+D=0
 double a = t.N.x * kierunek.x +
            t.N.y * kierunek.y +
            t.N.z * kierunek.z;     //rzut promienia na kierunek normalny do paszczyzny
 if( a == 0)
    return false;                   //promie rwnolegy do paszczyzny trjkta.
                                    //Ponisze wynika z podstawienia rwnania
                                    //promienia do rwnania paszczyzny
 double b = t.N.x * r0.x +
            t.N.y * r0.y +
            t.N.z * r0.z;
 double c = (-D - b) / a;

 if( c < 0)
    return false;                   //trjkt ley z niewaciwiej strony ekranu

 p.x = r0.x + kierunek.x * c;       //wsprzdne przecicia promienia z paszczyzn
 p.y = r0.y + kierunek.y * c;
 p.z = r0.z + kierunek.z * c;
 return true;
}
//---------------------------------------------------------------------------
//  Szukanie przecicia promienia z trjktem zabudowy sceny.
//  Parametry referencyjne s wypeniane, o ile przecicie istnieje.
//  p - punkt trafienia.
//  Najpierw wyznacza si przecicie promienia z paszczyzn trjkta.
//  Potem wyszukuje si paszczyzn osi ukadu XYZ, na ktr najwygodniej
//  zrzutowa trjkt i punkt cieniowo.
bool TPromien :: czy_trafia_w_trojkat( TTrojkat t, TPunkt &p)
{
 if( czy_trafia_w_plaszczyzne( t, p))   //jeli tak, wyznacza wsprzdne trafienia p
 {
    double max_kierunek = max( t.N.x, t.N.y, t.N.z);
    double p1x, p1y, p2x, p2y, p3x, p3y, px, py;    //wsprzdne po zrzutowaniu
    double pole, pole1, pole2, pole3;   //polowy test trafiania w trjkt
    if( max_kierunek == t.N.x)      //rzutowanie na paszczyzn YZ
    {
        p1x = t.p1.y;
        p1y = t.p1.z;
        p2x = t.p2.y;
        p2y = t.p2.z;
        p3x = t.p3.y;
        p3y = t.p3.z;
        px  = p.y;
        py  = p.z;
    }
    else
    if( max_kierunek == t.N.y)      //rzutowanie na paszczyzn XZ
    {
        p1x = t.p1.x;
        p1y = t.p1.z;
        p2x = t.p2.x;
        p2y = t.p2.z;
        p3x = t.p3.x;
        p3y = t.p3.z;
        px  = p.x;
        py  = p.z;
    }
    else                            //rzutowanie na XY
    {
        p1x = t.p1.x;
        p1y = t.p1.y;
        p2x = t.p2.x;
        p2y = t.p2.y;
        p3x = t.p3.x;
        p3y = t.p3.y;
        px  = p.x;
        py  = p.y;
    }
    pole  = fabs(( p2x-p1x) * (p3y-p1y) - (p2y-p1y) * (p3x-p1x)) / 2.;
    pole1 = fabs(( p2x-px) * (p3y-py) - (p2y-py) * (p3x-px)) / 2.;
    pole2 = fabs(( p1x-px) * (p3y-py) - (p1y-py) * (p3x-px)) / 2.;
    pole3 = fabs(( p2x-px) * (p1y-py) - (p2y-py) * (p1x-px)) / 2.;

    return (pole >= (pole1 + pole2 + pole3));    //trafi w trjkt
 }
 return false;
}
//---------------------------------------------------------------------------
//  Wywouj po sprawdzeniu, ze promien *this trafia w trjkt t
void TPromien :: daj_promien_odbity( TTrojkat t, TPunkt p, TPromien &r)
{
 r.r0 = p;                   //pocztek nowego (odbitego) promienia
 r.kierunek = suma( iloczyn( -2 * iloczyn_skalarny( kierunek, t.N), t.N), kierunek);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor merytoryczny. Uruchamia konstruktora klasy bazowej
//  obs - pozycja obserwatora,
//  eszer, ewys - rozmiary pikselowe pola obrazowego,
//  odl_ekr - odlego pola obrazowego [m],
//  szer, wys - rozmiar pola obrazowego [m].
TObraz :: TObraz( TPunkt Aobs, int eszer, int ewys,
            double Aodl_ekr, double szer, double wys) :
            TSkalowanie( 0, 0, eszer, ewys, 0, 0, szer, wys)
{
 obs = Aobs;
 Rxy = sqrt( obs.x * obs.x + obs.y * obs.y);
 R = sqrt( Rxy * Rxy + obs.z * obs.z);
 odl_ekr = Aodl_ekr;
 if( Rxy != 0)
    sf = obs.y / Rxy, cf = obs.x / Rxy;    //wspczynniki macierzy obrotu
 else
    sf = 0, cf = 1;

 st = Rxy / R, ct = obs.z / R;
}
//---------------------------------------------------------------------------
// Prywatna f. pomocnicza, konstruujca promien wychodzcy
//  od obserwatora i biegncy przez piksel (i, j) paszczyzny obrazowej.
TPromien TObraz :: daj_promien( int i, int j)
{
 double eh, ev;                 //metryczne wsprzdne piksela (i, j) w paszczynie ekranu
 TPunkt e;                      //metryczne wsprzdne piksela w przestrzeni 3d

 eh = daj_real_x( i);           //funkcje odziedziczone z klasy bazowej
 ev = daj_real_y( j);

 TPunkt z( -ev, eh, R-odl_ekr); //gdy ekran jest w zenicie, piksel ma takie wsprzdne

 e.x = cf * ct * z.x - sf * z.y + cf * st * z.z;
 e.y = sf * ct * z.x + cf * z.y + sf * st * z.z;
 e.z = -st * z.x + ct * z.z;

 return TPromien( obs, e);
}
//---------------------------------------------------------------------------
// Raczej niepotrzebne. Do testowania.
TPunkt TObraz :: daj_punkt( int i, int j)
{
 double eh, ev;                 //metryczne wsprzdne piksela (i, j) w paszczynie ekranu
 TPunkt e;                      //metryczne wsprzdne piksela w przestrzeni 3d

 eh = daj_real_x( i);           //funkcje odziedziczone z klasy bazowej
 ev = daj_real_y( j);

 TPunkt z( -ev, eh, R-odl_ekr); //gdy ekran jest w zenicie, piksel ma takie wsprzdne

 e.x = cf * ct * z.x - sf * z.y + cf * st * z.z;
 e.y = sf * ct * z.x + cf * z.y + sf * st * z.z;
 e.z = -st * z.x + ct * z.z;

 return e;
}
//---------------------------------------------------------------------------
//  Gwna funkcja algorytmu
TColor TObraz :: kolor_piksela( int i, int j)
{
 TColor k = clBlack;
 TPromien p = daj_promien( i, j);
 return k;
}
