//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
//  Konstruktor podstawowy
TTrojkat :: TTrojkat( TPunkt Ap1, TPunkt Ap2, TPunkt Ap3)
{
 p1 = Ap1;
 p2 = Ap2;
 p3 = Ap3;
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TTrojkat :: TTrojkat( const TTrojkat &t)
{
 p1 = t.p1;
 p2 = t.p2;
 p3 = t.p3;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TTrojkat & TTrojkat :: operator= (const TTrojkat &t)
{
 if( this != &t)
 {
    p1 = t.p1;
    p2 = t.p2;
    p3 = t.p3;
 }
 return *this;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor podstawowy. Promien z punktu Ar0, skierowany w Akierunek
TPromien :: TPromien( TPunkt Ar0, TWektor Akierunek)
{
 r0 = Ar0;
 kierunek = Akierunek;
}
//---------------------------------------------------------------------------
//  Inny konstruktor. Promien skierowany od a do b.
TPromien :: TPromien( TPunkt Aa, TPunkt Ab)
{
 r0 = Aa;
 kierunek = TWektor( Ab.x - Aa.x, Ab.y - Aa.y, Ab.z - Aa.z);
 kierunek.unormuj();
}
//---------------------------------------------------------------------------
//  Konstruktor kopiujcy
TPromien :: TPromien( const TPromien &p)
{
 r0 = p.r0;
 kierunek = p.kierunek;
}
//---------------------------------------------------------------------------
//  Operator przypisania
TPromien & TPromien :: operator= (const TPromien &p)
{
 if( this != &p)
 {
    r0 = p.r0;
    kierunek = p.kierunek;
 }
 return *this;
}
//---------------------------------------------------------------------------
//  Wyznaczenie punktu przecicia promienia z paszczyzn trjkta.
//  Za chwil wyznaczymy, czy punkt ten ley wewntrz trjkta,
//  tzn, czy promie trafia w trjkt.
//  Parametry referencyjne s wypeniane, o ile przecicie istnieje.
bool TPromien :: czy_trafia_w_plaszczyzne( TTrojkat t, TPunkt &p)
{
 TWektor v1( t.p1, t.p2), v2( t.p1, t.p3);  //wektory rozpinajce trjkt

 TWektor N = iloczyn_wektorowy( v1, v2);
 N.unormuj();                   //unormowany wektor prostopady do paszczyzny trjkta

 double D = -(N.x*t.p1.x + N.y*t.p1.y + N.z*t.p1.z);//wspczynnik D r-nia paszczyzny Ax+By+Cz+D=0
 double a = N.x*kierunek.x + N.y*kierunek.y + N.z*kierunek.z;  //pomocnicze
 if( a == 0)
    return false;                                   //promie rwnolegy do paszczyzny trjkta
                                                    //ponisze wynika z podstawienia rwnania
                                                    //promienia do rwnania paszczyzny
 double b = (-D - iloczyn_skalarny( N, TWektor( TPunkt(), r0))) / a;
 if( b < 0)
    return false;                                   //trjkt ley z niewaciwiej strony ekranu

 p.x = r0.x + kierunek.x * b;
 p.y = r0.y + kierunek.y * b;
 p.z = r0.z + kierunek.z * b;
 return true;
}
//---------------------------------------------------------------------------
//  Szukanie przecicia promienia z trjktem zabudowy sceny.
//  Parametry referencyjne s wypeniane, o ile przecicie istnieje.
bool TPromien :: czy_trafia_w_trojkat( TTrojkat t, TPunkt &trafienie, TPromien &odbicie)
{
 return czy_trafia_w_plaszczyzne( t, trafienie);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Konstruktor merytoryczny. Uruchamia konstruktora klasy bazowej
//  obs - pozycja obserwatora,
//  eszer, ewys - rozmiary pikselowe pola obrazowego,
//  odl_ekr - odlego pola obrazowego [m],
//  szer, wys - rozmiar pola obrazowego [m].
TObraz :: TObraz( TPunkt Aobs, int eszer, int ewys,
            double Aodl_ekr, double szer, double wys) :
            TSkalowanie( 0, 0, eszer, ewys, 0, 0, szer, wys)
{
 obs = Aobs;
 Rxy = sqrt( obs.x * obs.x + obs.y * obs.y);
 R = sqrt( Rxy * Rxy + obs.z * obs.z);
 odl_ekr = Aodl_ekr;
 if( Rxy != 0)
    sf = obs.y / Rxy, cf = obs.x / Rxy;    //wspczynniki macierzy obrotu
 else
    sf = 0, cf = 1;

 st = Rxy / R, ct = obs.z / R;
}
//---------------------------------------------------------------------------
//  Prywatna f. pomocnicza, konstruujca promien wychodzcy
//  od obserwatora i biegncy przez piksel (i, j) paszczyzny obrazowej.
TPromien TObraz :: daj_promien( int i, int j)
{
 double eh, ev;                 //metryczne wsprzdne piksela (i, j) w paszczynie ekranu
 TPunkt e;                      //metryczne wsprzdne piksela w przestrzeni 3d

 eh = daj_real_x( i);           //funkcje odziedziczone z klasy bazowej
 ev = daj_real_y( j);

 TPunkt z( -ev, eh, R-odl_ekr); //gdy ekran jest w zenicie, piksel ma takie wsprzdne

 e.x = cf * ct * z.x - sf * z.y + cf * st * z.z;
 e.y = sf * ct * z.x + cf * z.y + sf * st * z.z;
 e.z = -st * z.x + ct * z.z;

 return TPromien( obs, e);
}
//---------------------------------------------------------------------------
// Raczej niepotrzebne. Do testowania.
TPunkt TObraz :: daj_punkt( int i, int j)
{
 double eh, ev;                 //metryczne wsprzdne piksela (i, j) w paszczynie ekranu
 TPunkt e;                      //metryczne wsprzdne piksela w przestrzeni 3d

 eh = daj_real_x( i);           //funkcje odziedziczone z klasy bazowej
 ev = daj_real_y( j);

 TPunkt z( -ev, eh, R-odl_ekr); //gdy ekran jest w zenicie, piksel ma takie wsprzdne

 e.x = cf * ct * z.x - sf * z.y + cf * st * z.z;
 e.y = sf * ct * z.x + cf * z.y + sf * st * z.z;
 e.z = -st * z.x + ct * z.z;

 return e;
}
//---------------------------------------------------------------------------
//  Gwna funkcja algorytmu
TColor TObraz :: kolor_piksela( int i, int j)
{
 TColor k = clBlack;
 TPromien p = daj_promien( i, j);
 return k;
}
