//---------------------------------------------------------------------------
#ifndef obrazH
#define obrazH

#include "skala.h"
#include "geometria.h"
//---------------------------------------------------------------------------
//  Definicja elementu zabudowy sceny
class TTrojkat
{
 private:
    TPunkt a, b, c;         //punkty wyznaczajce trjkt
 public:
    TTrojkat( TPunkt Aa, TPunkt Ab, TPunkt Ac);
    TTrojkat( const TTrojkat &t);
    TTrojkat & operator= (const TTrojkat &t);
};
//---------------------------------------------------------------------------
//  Definicja promienia
class TPromien
{
 private:
    TPunkt r0;              //punkt zaczepienia
    TWektor kierunek;       //skierowanie, zadane wektorem (unormowanym)
 public:
    TPromien( TPunkt Aa, TPunkt Ab);
    TPromien( TPunkt Aa, TWektor Akierunek);
    TPromien( const TPromien &p);
    TPromien & operator= (const TPromien &);
    bool czy_trafia( TTrojkat t, TPunkt &trafienie, TPromien &odbicie);
};
//---------------------------------------------------------------------------
class TObraz : public TSkalowanie
{
 private:
    TPunkt obs;             //pozycja obserwatora
    double R, Rxy;          //odlego obserwatora i jej rzut na paszczyzn XY
    double odl_ekr;         //odlego ekranu od oczu
    TPromien daj_promien( int i, int j);//promien, przechodzcy przez piksel (i, j);
 public:
    TObraz( TPunkt Aobs,    //pozycja obserwatora
            int eszer, int ewys,//pikselowe pole obrazu
            double Aodl_ekr, //odlego pola obrazu
            double szer, double wys);//fizyczne pole obrazu
    TColor kolor_piksela( int i, int j);
    TPunkt daj_punkt( int i, int j);    //testowa
};
#endif
