//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fyoung_2.h"
#include "skala.h"
#include "widmo.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//  Gwna funkcja krelca.
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 double rozm_ekr = 0.005;//rozmiar ekranu (1 cm)
 double d, r, L;        //odl. szczelin, odl. ekranu, dugo fali
 double x, f;           //punkt ekranu i amplituda fali w nim
 double r1, r2;         //drogi przebywane przez obie fale
 int xe, ye1, ye2;      //wsprzdne ekranowe prka wietlnego
 TSkalowanie s( 0, 0, PaintBox1 -> Width, PaintBox1 -> Height,
           0, 0, rozm_ekr, rozm_ekr);
 TWidmo w;
 AnsiString napis;      //pomocnicze
 double k;
 TColor kolor;
 bool pierwszy_punkt = true;

 d = TrackBar1 -> Position / 100000.0; //typowe odlegoci szczelin
 r = TrackBar2 -> Position / 10.0;     //typowe oddalenie ekranu
 L = TrackBar3 -> Position / 1.0e10;   //dugo fali wiata

 k = 2*M_PI/L;          //parametr pomocniczy, tzw. liczba falowa
 ye1 = s.daj_ekr_y(-rozm_ekr);  //rozpito pionowa prkw
 ye2 = s.daj_ekr_y( rozm_ekr);
 PaintBox1 -> Canvas -> Pen -> Width = 7;

 for( x = -rozm_ekr/2; x <= rozm_ekr/2; x += 0.0001)
 {
    r1 = sqrt((x+d)*(x+d) + r*r);
    r2 = sqrt((x-d)*(x-d) + r*r);
    f  = cos(k*r1) + cos(k*r2);
    kolor = w.lambda_to_kolor( f*f*25, L);
    PaintBox1 -> Canvas -> Pen -> Color = kolor;
    xe = s.daj_ekr_x(x);
    PaintBox1 -> Canvas -> MoveTo( xe, ye1);
    PaintBox1 -> Canvas -> LineTo( xe, ye2);    //gruba linia
 }
}
//---------------------------------------------------------------------------
//  Koniec
void __fastcall TForm1::Button2Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------

