//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "3d.h"
#include "ftech1.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 inicjuj_parametry();
}
//---------------------------------------------------------------------------
void TForm1::inicjuj_parametry( void)
{
 double k = M_PI / 180.;
 double r = TrackBar1 -> Position,
        fi = k * TrackBar2 -> Position,
        teta = k * TrackBar3 -> Position, x, y, z;

 x = r * cos( fi) * sin( teta);
 y = r * sin( fi) * sin( teta);
 z = r * cos( teta);

 Pobs = TPunkt( x, y, z);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 inicjuj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int piksel_szer = 60, piksel_wys = 40;
 TPunkt oko( 10, 10, 5);
 TObraz obraz( oko, piksel_szer, piksel_wys, 3, 1.8, 1.2);
 T3d d( Pobs, 0, 0, PaintBox1 -> Width, PaintBox1 -> Height, 0.3);


 TPunkt p0( 0, 0, 0);               //rodek ukadu XYZ
 TPunkt p1, p2, p3, p4;             //rogi ekranu
 TPunkt p1xy, p2xy, p3xy, p4xy;     //rogi rzutu ekranu na XY
 TPunkt p, pxy, px, py, pz;         //przykadowy punkt
 
 p1xy = p1 = obraz.daj_punkt( 0, 0);
 p2xy = p2 = obraz.daj_punkt( piksel_szer, 0);
 p3xy = p3 = obraz.daj_punkt( piksel_szer, piksel_wys);
 p4xy = p4 = obraz.daj_punkt( 0, piksel_wys);

 p1xy.z = p2xy.z = p3xy.z = p4xy.z = 0;

                                    //ekran
 linia3d( p1, p2, &d, PaintBox1 -> Canvas, clBlue);
 linia3d( p2, p3, &d, PaintBox1 -> Canvas, clBlue);
 linia3d( p3, p4, &d, PaintBox1 -> Canvas, clBlue);
 linia3d( p4, p1, &d, PaintBox1 -> Canvas, clBlue);

                                    //rzut ekranu na XY
 linia3d( p1xy, p2xy, &d, PaintBox1 -> Canvas, clGray);
 linia3d( p2xy, p3xy, &d, PaintBox1 -> Canvas, clGray);
 linia3d( p3xy, p4xy, &d, PaintBox1 -> Canvas, clGray);
 linia3d( p4xy, p1xy, &d, PaintBox1 -> Canvas, clGray);


                                    //Linie rzutowania
 linia3d( p1xy, p1, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p2xy, p2, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p3xy, p3, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p4xy, p4, &d, PaintBox1 -> Canvas, clSilver);

                                    //Ukad odniesienia
 linia3d( p0, TPunkt( 10, 0, 0), &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p0, TPunkt( 0, 10, 0), &d, PaintBox1 -> Canvas, clSilver);
 linia3d( p0, TPunkt( 0, 0, 10), &d, PaintBox1 -> Canvas, clSilver);


 for( int i = 0; i < piksel_szer; i += 2)    //cie ekranu
 {
    for( int j = 0; j < piksel_wys; j += 2)
    {
        p = obraz.daj_punkt( i, j);
        punkt3d( p, &d, PaintBox1 -> Canvas, clSilver);
        p.z = 0;
        punkt3d( p, &d, PaintBox1 -> Canvas, clSilver);
    }
 }

                                    //Graniastosup widzenia
 linia3d( oko, p1, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( oko, p2, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( oko, p3, &d, PaintBox1 -> Canvas, clSilver);
 linia3d( oko, p4, &d, PaintBox1 -> Canvas, clSilver);

                                    //o gwna
 linia3d( oko, p0, &d, PaintBox1 -> Canvas, clSilver);

                                    //przykadowy punkt
 PaintBox1 -> Canvas -> Pen -> Color = clGray;
 p = pxy = px = py = pz = obraz.daj_punkt( 50, 10);
 pxy.z = px.y = px.z = py.x = py.z = pz.x = pz.y = 0;

 linia3d( oko, p, &d, PaintBox1 -> Canvas, clRed);

 linia3d( p, pz, &d, PaintBox1 -> Canvas, clGray);
 linia3d( p, pxy, &d, PaintBox1 -> Canvas, clGray);
 linia3d( pxy, px, &d, PaintBox1 -> Canvas, clGray);
 linia3d( pxy, py, &d, PaintBox1 -> Canvas, clGray);
}
//---------------------------------------------------------------------------
//  Wywietlenie punktu. Pomocnicze.
void TForm1 :: punkt3d( TPunkt p, T3d *d, TCanvas *cnv, TColor kolor)
{
 int xe, ye;
 d -> punkt_3d( xe, ye, p);
 cnv -> Pixels[ xe][ ye] = kolor;
}
//---------------------------------------------------------------------------
//  Wywietlenie linii czcej 2 punkty. Pomocnicze.
void TForm1 :: linia3d( TPunkt p1, TPunkt p2, T3d *d, TCanvas *cnv, TColor kolor)
{
 int xe, ye;
 cnv -> Pen -> Color = kolor;
 d -> punkt_3d( xe, ye, p1);
 cnv -> MoveTo( xe, ye);
 d -> punkt_3d( xe, ye, p2);
 cnv -> LineTo( xe, ye);
}
//---------------------------------------------------------------------------

