//---------------------------------------------------------------------------
#ifndef geometriaH
#define geometriaH

#include "math.h"       //w kocwce pliku pojawia si napis "sqrt"
//---------------------------------------------------------------------------
//  Obiekt pomocniczy, skracajcy zapis wsprzdnych
class TPunkt
{
 private:
 public:
    double x, y, z;
    TPunkt( void);
    TPunkt( double x, double y, double z);
    TPunkt( const TPunkt &p);               //konstruktor kopiujcy
    TPunkt & operator= (const TPunkt &);
};
//---------------------------------------------------------------------------
//  Obiekt pomocniczy, skracajcy zapis wsprzdnych.
//  Funkcja wylicz_... przydatna w klasieTRelatyw3d
class TLinia
{
 private:
 public:
    double x1, y1, z1, x2, y2, z2;
    TLinia( void);
    TLinia( TPunkt p1, TPunkt p2);
    TLinia( const TLinia &l);                //konstruktor kopiujcy
    TLinia & operator= (const TLinia &);
    TPunkt wylicz_punkt_na_linii( int nr, int il_podzial);
};
//---------------------------------------------------------------------------
//  Definicja wektora 3d, przydatna w zagadnieniu Ray Tracingu
class TWektor
{
 private:
 public:
    double x, y, z;
    TWektor( void);
    TWektor( double Ax, double Ay, double Az);
    TWektor( TPunkt poczatek, TPunkt koniec);
    TWektor( const TWektor &w);
    TWektor & operator= (const TWektor &);
    void unormuj( void);    //czy wektor wektorem jednostkowym
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//  Pomocnicze funkcje nie nalece do klas
//---------------------------------------------------------------------------
//  Odlego 2 punktw
inline double odleglosc( TPunkt pa, TPunkt pb)
{
 return sqrt((pa.x-pb.x)*(pa.x-pb.x)+(pa.y-pb.y)*(pa.y-pb.y)+(pa.z-pb.z)*(pa.z-pb.z));
}
//---------------------------------------------------------------------------
//  iloczyn liczby i wektora (wyduanie / skracanie wektora)
inline TWektor iloczyn( double a, TWektor v)
{
 return TWektor(v.x * a, v.y * a, v.z * a);
}
//---------------------------------------------------------------------------
//  iloczyn skalarny dwch wektorw
inline double iloczyn_skalarny( TWektor v1, TWektor v2)
{
 return (v1.x * v2.x + v1.y * v2.y + v1.z * v2.z);
}
//---------------------------------------------------------------------------
//  iloczyn wektorowy dwch wektorw
inline TWektor iloczyn_wektorowy( TWektor v1, TWektor v2)
{
 return TWektor( v1.y * v2.z - v1.z * v2.y,
                 v1.z * v2.x - v1.x * v2.z,
                 v1.x * v2.y - v1.y * v2.x);
}
//---------------------------------------------------------------------------
//  suma dwch wektorw
inline TWektor suma( TWektor v1, TWektor v2)
{
 return TWektor( v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
}
//---------------------------------------------------------------------------
#endif
