//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "obraz.h"
#include "3d.h"
#include "fobraz1.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
 jasnosc_proc = TrackBar1 -> Position;
 il_odbic     = TrackBar2 -> Position;
}
//---------------------------------------------------------------------------
//  Zabudowa sceny.
void __fastcall TForm1::FormShow(TObject *Sender)
{
 int i, j;
 for( i = -4; i <= 4; i+=2)
 {
    for( j = -4; j <= 4; j+=2)
    {
        poziomy_kwadrat( TPunkt( i, j, 1), clWhite);
        poziomy_kwadrat( TPunkt( i, j, -1), clGray);
    }
 }
}
//---------------------------------------------------------------------------
//  Funkcja pomocnicza - wykrrelenie kwadratu jako 4 trjktw
void TForm1::poziomy_kwadrat( TPunkt p, TColor kolor)
{
 double d = 0.9;
 TSwiatlo s( GetRValue( kolor), GetGValue( kolor), GetBValue( kolor));
 TOdbicie o( 0.2, 0.2, 0.2);
 TPunkt p1( p.x-d, p.y+d, p.z), p2( p.x+d, p.y+d, p.z),
        p3( p.x+d, p.y-d, p.z), p4( p.x-d, p.y-d, p.z);
 scena.dodaj_trojkat( TTrojkat( p1, p2, p, s, o));
 scena.dodaj_trojkat( TTrojkat( p2, p3, p, s, o));
 scena.dodaj_trojkat( TTrojkat( p3, p4, p, s, o));
 scena.dodaj_trojkat( TTrojkat( p4, p1, p, s, o));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 jasnosc_proc = TrackBar1 -> Position;
 il_odbic     = TrackBar2 -> Position;
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 int piksel_szer = PaintBox1 -> Width, piksel_wys = PaintBox1 -> Height;
 TPunkt oko( 10, 10, 10);
 TObraz obraz( oko,                 //pozycja oka
               piksel_szer, piksel_wys,//pikselowe pole obrazu
               0.5,                 //odlego oka od pola obrazu
               0.5, 0.5,            //metryczne pole obrazu
               &scena,              //zabudowana obiektami
               il_odbic);           //gboko rekurencji

 for( int i = PaintBox1 -> Canvas -> ClipRect.Left; i < PaintBox1 -> Canvas -> ClipRect.Right; i ++)      //obraz
 {
    for( int j = PaintBox1 -> Canvas -> ClipRect.Top; j < PaintBox1 -> Canvas -> ClipRect.Bottom; j ++)
    {
        PaintBox1 -> Canvas -> Pixels[i][j] = obraz.kolor_piksela( i, j, jasnosc_proc);
    }
 }
}
//---------------------------------------------------------------------------

