//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fyoung_1.h"
#include "skala.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//  Gwna funkcja krelca.
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 double rozm_ekr = 0.005;//rozmiar ekranu (1 cm)
 double d, r, L;        //odl. szczelin, odl. ekranu, dugo fali
 double x, f;           //punkt ekranu i amplituda fali w nim
 double r1, r2;         //drogi przebywane przez obie fale
 int xe, ye;            //wsprzdne ekranowe punktu wykresu.
 TSkalowanie s( 0, 0, PaintBox1 -> Width, PaintBox1 -> Height,
           0, 3, 1.2 * rozm_ekr, 8);
 AnsiString napis;      //pomocnicze
 double k;
 bool pierwszy_punkt = true;

 d = TrackBar1 -> Position / 100000.0; //typowe odlegoci szczelin
 r = TrackBar2 -> Position / 10.0;     //typowe oddalenie ekranu
 L = TrackBar3 -> Position / 1.0e10;    //dugo fali wiata

 k = 2*M_PI/L;          //parametr pomocniczy, tzw. liczba falowa

 PaintBox1 -> Canvas -> Pen -> Color = clBlue;
 PaintBox1 -> Canvas -> Pen -> Width = 2;
 for( x = -rozm_ekr/2; x <= rozm_ekr/2; x += 0.00002)
 {
    r1 = sqrt((x+d)*(x+d) + r*r);
    r2 = sqrt((x-d)*(x-d) + r*r);
    f  = cos(k*r1) + cos(k*r2);
    xe = s.daj_ekr_x(x);
    ye = s.daj_ekr_y(f*f);   //kwadrat amplitudy
    if( pierwszy_punkt)
    {
        PaintBox1 -> Canvas -> MoveTo( xe, ye);
        pierwszy_punkt = false;
    }
    PaintBox1 -> Canvas -> LineTo( xe, ye);
 }
 napis = Label1 -> Caption + ": " + AnsiString( d);
 PaintBox1 -> Canvas -> TextOut( 10, 10, napis);
 napis = Label2 -> Caption + ": " + AnsiString( r);
 PaintBox1 -> Canvas -> TextOut( 10, 25, napis);
 napis = Label3 -> Caption + ": " + AnsiString( L);
 PaintBox1 -> Canvas -> TextOut( 10, 40, napis);
}
//---------------------------------------------------------------------------
//  Koniec
void __fastcall TForm1::Button2Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------

