//---------------------------------------------------------------------------
// Interferencja wiata
//
#include <vcl\vcl.h>
#pragma hdrstop

#include "fprzesl.h"
#include "fekran.h"
#include "math.h"
#include "skala.h"
//---------------------------------------------------------------------------
#pragma link "Grids"
#pragma resource "*.dfm"
TPrzeslona *Przeslona;
//---------------------------------------------------------------------------
__fastcall TPrzeslona::TPrzeslona(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
// Inicjowanie parametrw.
// Wpisanie okrgego otworka w tablic P.

void __fastcall TPrzeslona::FormShow(TObject *Sender)
{
 inicjuj_parametry();
                            //pojedynczy otworek na rodku
 int i, j, a = IL_PODZ / 2;

 for( i = 0; i < IL_PODZ; i ++)
    for( j = 0; j < IL_PODZ; j ++)
        P[ i][ j] = 0;  //nie ma dziurek

               P[a-1][a-2] = P[a][a-2] = P[a+1][a-2] = 1;
 P[a-2][a-1] = P[a-1][a-1] = P[a][a-1] = P[a+1][a-1] = P[a+2][a-1] = 1;
 P[a-2][a] = P[a-1][a] = P[a][a] = P[a+1][a] = P[a+2][a] = 1;
 P[a-2][a+1] = P[a-1][a+1] = P[a][a+1] = P[a+1][a+1] = P[a+2][a+1] = 1;
               P[a-1][a+2] = P[a][a+2] = P[a+1][a+2] = 1;
}
//---------------------------------------------------------------------------
//  Wyodrbniony algorytm sczytywania nastaw interfejsu.
void TPrzeslona::inicjuj_parametry( void)
{
 try                        //spodziewamy si rnych bdw w danych
 {
    rozm_p = 0.001*Edit1 -> Text.ToDouble();   //szeroko przesony
    rozm_e = 0.001 * Edit2 -> Text.ToDouble(); //szeroko ekranu
    odl = Edit3 -> Text.ToDouble();            //odlego ekran-przesona
    L = 1e-6 * Edit4 -> Text.ToDouble();       //dg. fali wiata
 }
 catch(...)                 //nie zmienione wartoci parametrw
 {
 }
}
//---------------------------------------------------------------------------
// Wywietlenie przesony
// Oczko przesony jest te, gdy jest tam dziurka dla wiata...
void __fastcall TPrzeslona::DrawGrid1DrawCell(TObject *Sender, int Col,
	int Row, TRect &Rect, TGridDrawState State)
{
 if( P[Col][Row] > 0)
    DrawGrid1 -> Canvas -> Brush -> Color = clYellow;
 else
    DrawGrid1 -> Canvas -> Brush -> Color = clBlue;

 DrawGrid1 -> Canvas -> FillRect( Rect);
}
//---------------------------------------------------------------------------
// Zbuduj obraz amplitud fal w tablicy E (ekran).
void TPrzeslona :: interferuj( void)
{
 int i, j, m, n;
 double x_p, y_p, x_e, y_e;   //bieca pozycja na przes. i ekr.
 double r;                    //odlego biecych pozycji przys. - ekr.
 double odl2 = odl*odl;       //pomocnicze - kwadrat odlegoci przys.-ekr.
 double k = 2 * M_PI/L;       //pomocnicze - tzw. liczba falowa
 double suma_fal, max_suma_fal = 0;	//amplituda zoenia fal ze wszystkich otworkw
 TSkalowanie s_p( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, rozm_p, rozm_p);
 TSkalowanie s_e( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, rozm_e, rozm_e);

 for( i = 0; i < IL_PODZ; i++)
 {
    x_e = s_e.daj_real_x( i);
    for( j = 0; j < IL_PODZ; j++)
    {
        y_e = s_e.daj_real_y( j);
        suma_fal = 0.0;             //wane. Za chwil zbierzemy tutaj amplitudy
        for( m = 0; m < IL_PODZ; m++)
        {
            x_p = s_p.daj_real_x( m);
            for( n = 0; n < IL_PODZ; n++)
            {
                if( P[m][n]!=0)    //jest dziurka?
                {
                    y_p = s_p.daj_real_y( n);
                    r = sqrt((x_e-x_p) * (x_e-x_p) + (y_e-y_p) * (y_e-y_p) + odl2);
                    suma_fal += P[m][n] * sin( k*r);
                }
            }
        }
        Ekran -> E[i][j] = suma_fal; //przechowanie wyliczonej amplitudy
        if( suma_fal < -max_suma_fal || suma_fal > max_suma_fal)
       	    max_suma_fal = suma_fal; //wyapanie najwikszej amplitudy
    }
 }
 if( max_suma_fal != 0)
 {
    for( i = 0; i < IL_PODZ; i ++)   //zawarto tablicy unormuj do zakresu -1 ...+1
	    for( j = 0; j < IL_PODZ; j ++)
            Ekran -> E[i][j] = Ekran -> E[i][j] / max_suma_fal;
 }
}
//---------------------------------------------------------------------------
// Odwie ekran
void __fastcall TPrzeslona::Button1Click(TObject *Sender)
{
 inicjuj_parametry();
 interferuj();
 Ekran -> Show();
 Ekran -> DrawGrid1 -> Refresh();       //poka ekran
}
//---------------------------------------------------------------------------
// Zakocz
void __fastcall TPrzeslona::Button2Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------
// Nacinito myszk na przesonie
void __fastcall TPrzeslona::DrawGrid1MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
 start_zaznacz_x = DrawGrid1 -> Col;    //pocztek zaznaczania
 start_zaznacz_y = DrawGrid1 -> Row;
}
//---------------------------------------------------------------------------
// Puszczono myszk
// Zmie stan otworkw midzy t pozycj myszki a miejscem jej nacinicia
void __fastcall TPrzeslona::DrawGrid1MouseUp(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
 int i, j, a, b, c, d;

 if( start_zaznacz_x < DrawGrid1 -> Col)
 {
    a = start_zaznacz_x;
    b = DrawGrid1 -> Col;
 }
 else
 {
    a = DrawGrid1 -> Col;
    b = start_zaznacz_x;
 }

 if( start_zaznacz_y < DrawGrid1 -> Row)
 {
    c = start_zaznacz_y;
    d = DrawGrid1 -> Row;
 }
 else
 {
    c = DrawGrid1 -> Row;
    d = start_zaznacz_y;
 }

 for( i = a; i <= b; i ++)
    for( j = c; j <= d; j ++)
        P[i][j] = P[i][j] == 0? 1 : 0;   //negacja ukadu dziurek

 DrawGrid1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TPrzeslona::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Close();
}
//---------------------------------------------------------------------------

