//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "wykr3d.h"
#include "3d.h"
#include "finterf3d_2.h"
#include "math.h"
#include "widmo.h"
#include "skala.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//  Konstruktor obiektu krelcego
TWykres :: TWykres(
    TPunkt obserwator,                      //pozycja obserwatora
    TPunkt oswietlenie,                     //pozycja punktu owietlajcego
    double xr0, double yr0, double rszer, double rwys,//obszar funkcji
    int il_x, int il_y,                     //dokadno krelenia - liczba podziaw dziedziny
    int xe0, int ye0, int eszer, int ewys)  //okno ekranowe
	: TWykres3d(  obserwator, oswietlenie,
                xr0, yr0, rszer, rwys,
                il_x, il_y, xe0, ye0, eszer, ewys)
{
}
//---------------------------------------------------------------------------
//  Inicjowanie parametrw.
//  Wpisanie okrgego otworka w tablic P.
void __fastcall TForm1::FormShow(TObject *Sender)
{
 inicjuj_parametry();
                            //pojedynczy otworek na rodku
 int i, j, a = IL_PODZ / 2;

 for( i = 0; i < IL_PODZ; i ++)
    for( j = 0; j < IL_PODZ; j ++)
        P[ i][ j] = 0;      //nie ma dziurek

               P[a-1][a-2] = P[a][a-2] = P[a+1][a-2] = 1;
 P[a-2][a-1] = P[a-1][a-1] = P[a][a-1] = P[a+1][a-1] = P[a+2][a-1] = 1;
 P[a-2][a] = P[a-1][a] = P[a][a] = P[a+1][a] = P[a+2][a] = 1;
 P[a-2][a+1] = P[a-1][a+1] = P[a][a+1] = P[a+1][a+1] = P[a+2][a+1] = 1;
               P[a-1][a+2] = P[a][a+2] = P[a+1][a+2] = 1;
}
//---------------------------------------------------------------------------
//  Wyodrbniony algorytm sczytywania nastaw interfejsu.
void TForm1::inicjuj_parametry( void)
{
 try                        //spodziewamy si rnych bdw w danych
 {
    L = TrackBar1 -> Position * 1e-9;
    z_p=Edit1 -> Text.ToDouble();
    z_e=Edit3 -> Text.ToDouble();
    rozm_p=Edit2 -> Text.ToDouble();
    rozm_e=Edit4 -> Text.ToDouble();
    obs.x=Edit5 -> Text.ToDouble();
    obs.y=Edit6 -> Text.ToDouble();
    obs.z=Edit7 -> Text.ToDouble();
 }
 catch(...)                 //nie zmienione wartoci parametrw
 {
 }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TPunkt osw( -5., 10., 0.); //pozycja owietlenia
 TWykres w3d( obs, osw,
    0., 0., rozm_e, rozm_e, //obszar funkcji
    IL_PODZ, IL_PODZ,       //dokadno krelenia
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height);//okno ekranowe
 int xe1, ye1, xe2, ye2, xe3, ye3, xe4, ye4, jasn;
 int a;
 TPoint p[ 5];
 TColor kolor;

 PaintBox1 -> Canvas -> Pen -> Color = clSilver;
 w3d.inicjuj_iterator();            //pocztek krelenia
 while( w3d.iterator( xe1, ye1, xe2, ye2, xe3, ye3, xe4, ye4, jasn))
 {
  p[ 0].x = xe1;                    //opis elementarnego czworokcika
  p[ 0].y = ye1;

  p[ 1].x = xe2;
  p[ 1].y = ye2;

  p[ 2].x = xe3;
  p[ 2].y = ye3;

  p[ 3].x = xe4;
  p[ 3].y = ye4;

  p[ 4].x = xe1;
  p[ 4].y = ye1;

  a = (int)((double)jasn * 2.5);    //pomocnicze
  kolor = (TColor)RGB( a, a, a);    //synteza koloru z amplitud RGB - tutaj szaro
  PaintBox1 -> Canvas -> Brush -> Color = kolor; //kolor wypenienia czworokcika
  PaintBox1 -> Canvas -> Polygon( p, 4);
 }
}
//---------------------------------------------------------------------------
//	Przedefiniowana funkcja obiektu podstawowego.
//  Oblicza sum fal w punkcie (x, y, z = 0).
double TWykres :: fun( double x, double y)
{
 int i, j;                      //pozycja w przysonie ...
 double x_p, y_p;               //... i jej odpowiednik w realu
 double r;                      //odlego biecych pozycji przys. - ekr.
 double odl2 = Form1->z_p*Form1->z_p;  //pomocnicze - kwadrat odlegoci przys.-ekr.
 double k = 2 * M_PI/Form1->L;  //pomocnicze - tzw. liczba falowa
 double suma_fal=0;	            //amplituda zoenia fal ze wszystkich otworkw
 TSkalowanie s( 0, 0, IL_PODZ-1, IL_PODZ-1, 0, 0, Form1->rozm_p, Form1->rozm_p);

 for( i=0; i<IL_PODZ; i++)
 {
    x_p = s.daj_real_x( i);
    for( j=0; j<IL_PODZ; j++)
    {
       if( Form1->P[i][j]!=0)   //jest dziurka?
       {
          y_p = s.daj_real_y( j);
          r = sqrt((x-x_p)*(x-x_p) + (y-y_p)*(y-y_p) + odl2);
          suma_fal += Form1->P[ i][ j] * sin( k*r);
       }
    }
 }
 return 0.0000003 * suma_fal*suma_fal;  //owietlenie to kwadrat amplitudy
}
//---------------------------------------------------------------------------
//  Rysowanie
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 inicjuj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
//  Koniec
void __fastcall TForm1::Button3Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------

