//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "math.h"
#include "3d.h"
//---------------------------------------------------------------------------
//	Konstruktor gwny, inicjujcy wszystkie parametry przeksztacenia 3d
//  Trzy ostatnie paramtry nie s wymagane.
T3d::T3d( TPunkt obs,                               //pozycja obserwatora
	int xe0, int ye0, int eszer, int ewys,          //okno ekranowe w pikselach
	double odl_ekr/*=0.5*/,
    double szer_ekr/*=0*/, double wys_ekr/*=0*/)    //fizyczny opis ekranu w metrach
{
 double r1, a;

 if( szer_ekr <=0)                                  //gdy nie okrelono rozmiarw ekranu
    szer_ekr = (double)eszer * 0.0257 / 96.;        //0.0257 m = 1 cal. Ekran ma 96 pikseli/cal
 if( wys_ekr <=0)
    wys_ekr  = (double)ewys  * 0.0257 / 96.;

 r1 = obs.x * obs.x + obs.y * obs.y;
 a = sqrt( r1);                                     //odl. w paszczynie XY
 R = sqrt( r1 + obs.z * obs.z);                     //odl. oka od centrum
 if( a != 0)                                        //wyliczenie wspczynnikw macierzy obrotu
 {
    sf = obs.y / a;                                 //sin( fi)
    cf = obs.x / a;                                 //cos( fi)
 }
 else
 {
    sf = 0;
    cf = 1;
 }
 st = a / R;                                        //sin( teta)
 ct = obs.z / R;                                    //cos( teta)

 A = (double)eszer / szer_ekr;                      //przekszt. lin.
 B = xe0 + A * szer_ekr / 2.;
 C = -(double)ewys / wys_ekr;
 D = ye0 - C * wys_ekr / 2.;

 fodl_ekr = odl_ekr;                                //dla moveto_3d()
}
//---------------------------------------------------------------------------
//	Wylicz wsprzdne punktu z przestrzeni 3d
bool T3d :: punkt_3d( int &xe, int &ye, TPunkt p)
{
 double xn, yn, zn;                                 //punkt 3d w ukadzie komputerowca

 xn = - 	 sf * p.x + cf * p.y;                       //transformacja
 yn = - cf * ct * p.x - sf * ct * p.y + st * p.z;
 zn = - cf * st * p.x - sf * st * p.y - ct * p.z + R;

 if( zn == 0)                                       //punkt drapn komputerowca w oko ...
    return false;

 xe = A * xn * fodl_ekr / zn + B;                   //twierdzenie Talesa ...
 ye = C * yn * fodl_ekr / zn + D;

 return true;
}

