//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "fekran.h"
#include "widmo.h"
//---------------------------------------------------------------------------
#pragma link "Grids"
#pragma resource "*.dfm"
TEkran *Ekran;
//---------------------------------------------------------------------------
// Konstruktor okienka - ekranu
// Poniewa siatka "DrawGridu" jest tutaj niewidoczna,
// konstruktor inicjuje rozmiar okienka.
__fastcall TEkran::TEkran(TComponent* Owner) : TForm(Owner)
{
 Ekran -> ClientWidth = DrawGrid1 -> DefaultColWidth * DrawGrid1 -> ColCount;
 Ekran -> ClientHeight = DrawGrid1 -> DefaultRowHeight * DrawGrid1 -> RowCount;
}
//---------------------------------------------------------------------------
// Zalenie od amplitud, zebranych w tablicy E[ ][ ], zabarwiamy ekran
// wiatem o dg. fali lambda, ale o rnych jasnociach.
void __fastcall TEkran::DrawGrid1DrawCell(TObject *Sender, int Col, int Row,
    TRect &Rect, TGridDrawState State)
{
 float kwadrat_sumy_fal;
 TWidmo w;
 TColor kolor;                      //do syntezy barwy fizycznej

 kwadrat_sumy_fal = 100.0 * E[Col][Row] * E[Col][Row];  //postrzegamy kwadrat amplitudy fali

 kolor = w.lambda_to_kolor( (int)kwadrat_sumy_fal, Przeslona -> L); //zamiana dg. fali na amplitudy R, G i B

 DrawGrid1 -> Canvas -> Brush -> Color = kolor; //z uzyskanych amplitud zoenie koloru windowsowego
 DrawGrid1 -> Canvas -> FillRect( Rect);
}
//---------------------------------------------------------------------------
void __fastcall TEkran::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Przeslona -> Close();           //zamknij okno gwne
}
//---------------------------------------------------------------------------
