//---------------------------------------------------------------------------
//	Skadanie drga - dudnienia
//
#include <vcl\vcl.h>
#pragma hdrstop

#include "ffale_2.h"
#include "math.h"
#include "skala.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner): TForm(Owner)
{
}
//---------------------------------------------------------------------------
//	Funkcja - reakcja na zdarzenie OnShow - okienko pojawia si na ekranie
void __fastcall TForm1::FormShow(TObject *Sender)
{
 TrackBar1Change( Sender);              //zainicjuj parametry fal
 TrackBar2Change( Sender);
 TrackBar3Change( Sender);
 TrackBar4Change( Sender);
 TrackBar5Change( Sender);
 TrackBar6Change( Sender);
}
//---------------------------------------------------------------------------
//	Funkcja - reakcja na zdarzenie OnPaint
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int xe1_old, ye1_old, xe2_old, ye2_old, xe3_old, ye3_old;				//wsprzdne ekranowe
 int xe1, ye1, xe2, ye2, xe3, ye3;      //wsprzdne ekranowe
 double x, y1, y2, y3;                  //wsprzdne rzeczywiste
 double k1, k2;                         //parametry pomocnicze
 bool pierwszy = true;
 int a = ClientHeight / 3;              //pomocnicze
 TSkalowanie s1( Panel1 -> Width, 0, ClientWidth - Panel1 -> Width, a, 0, 0, 20, 10);
 TSkalowanie s2( Panel1 -> Width, a, ClientWidth - Panel1 -> Width, a, 0, 0, 20, 10);
 TSkalowanie s3( Panel1 -> Width, 2 * a, ClientWidth - Panel1 -> Width, a, 0, 0, 20, 20);

 k1 = 2 * M_PI / L1;
 k2 = 2 * M_PI / L2;

 Canvas -> Pen -> Width = 2;
 for( x = -10; x < 10; x += 0.1)
 {
    y1 = A1 * sin( k1 * x + f1);        //pierwszy przebieg
    xe1 = s1.daj_ekr_x( x);
    ye1 = s1.daj_ekr_y( y1);

    y2 = A2 * sin( k2 * x + f2);        //drugi przebieg
    xe2 = s2.daj_ekr_x( x);
    ye2 = s2.daj_ekr_y( y2);

    y3 = y1 + y2;                       //suma
    xe3 = s3.daj_ekr_x( x);
    ye3 = s3.daj_ekr_y( y3);

    if( pierwszy)                       //pocztek krelenia?
    {
        xe1_old = xe1;
        ye1_old = ye1;
        xe2_old = xe2;
        ye2_old = ye2;
        xe3_old = xe3;
        ye3_old = ye3;

        pierwszy = false;
    }
    Canvas -> Pen -> Color = clYellow;
    Canvas -> MoveTo( xe1_old, ye1_old);
    Canvas -> LineTo( xe1, ye1);

    Canvas -> MoveTo( xe2_old, ye2_old);
    Canvas -> LineTo( xe2, ye2);

    Canvas -> Pen -> Color = clRed;
    Canvas -> MoveTo( xe3_old, ye3_old);
    Canvas -> LineTo( xe3, ye3);

    xe1_old = xe1;                      //koce odcinkw staj si pocztkami nastpnych
    ye1_old = ye1;
    xe2_old = xe2;
    ye2_old = ye2;
    xe3_old = xe3;
    ye3_old = ye3;
 }
}
//---------------------------------------------------------------------------
//	A1
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 A1 = (double)TrackBar1 -> Position / 2.;
 Refresh();
}
//---------------------------------------------------------------------------
//	L1
void __fastcall TForm1::TrackBar2Change(TObject *Sender)
{
 L1 = (double)TrackBar2 -> Position / 5. + 0.1;
 Refresh();
}
//---------------------------------------------------------------------------
//	f1
void __fastcall TForm1::TrackBar3Change(TObject *Sender)
{
 f1 = (double)TrackBar3 -> Position / 5.;
 Refresh();
}
//---------------------------------------------------------------------------
//	A2
void __fastcall TForm1::TrackBar4Change(TObject *Sender)
{
 A2 = (double)TrackBar4 -> Position / 2.;
 Refresh();
}
//---------------------------------------------------------------------------
//	L2
void __fastcall TForm1::TrackBar5Change(TObject *Sender)
{
 L2 = (double)TrackBar5 -> Position / 5. + 0.1;
 Refresh();
}
//---------------------------------------------------------------------------
//	f2
void __fastcall TForm1::TrackBar6Change(TObject *Sender)
{
 f2 = (double)TrackBar6 -> Position / 5.;
 Refresh();
}
//---------------------------------------------------------------------------
//	Nacinito klawisz ...
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
 	Close();
}
//---------------------------------------------------------------------------
