//---------------------------------------------------------------------------
#ifndef diagramH
#define diagramH
#include "skala.h"

// typy punktw do funkcji punkt()
enum TypPunktu{ P_Kolo, P_Kwadrat, P_Krzyz};
//---------------------------------------------------------------------------
//	Wykrelenie kartezjaskiego ukadu wsprzdnych
//	Klasa dziedziczy algorytmy po ojcu TSkalowanie
class TDiagram : public TSkalowanie
{
 private:
   TCanvas *canvas;
   double xr0, yr0, rszer, rwys;
 public:
   TDiagram( int xe0, int ye0, int eszer, int ewys,
   	double Axr0, double Ayr0, double Arszer, double Arwys,
       TCanvas *Acanvas);

	void siatka( double x0, double y0,
   	double x1, double x2,
       double y1, double y2,
       double dx, double dy, TColor kolor=clGray);
	void siatka( double x0, double y0,
       double dx, double dy, TColor kolor=clGray);
	void siatka( double dx, double dy, TColor kolor=clGray);

	void uklad_xy( double x0, double y0,
   	double x1, double x2,
       double y1, double y2,
       double dx, double dy,
       int delta, TColor kolor=clGray);
	void uklad_xy( double x0, double y0,
       double dx, double dy,
       int delta, TColor kolor=clGray);
	void uklad_xy( double dx, double dy,
       int delta, TColor kolor=clGray);

   void napis( double x, double y, AnsiString tekst);

   void punkt( double x, double y, int delta,
               TypPunktu typ=P_Kolo, TColor kolor=clGray);
};
#endif
