//---------------------------------------------------------------------------
//	Biorytmy
//
#include <vcl\vcl.h>
#pragma hdrstop

#include "diagram.h"                //Obiekt TDiagram
#include "fbiorytm_1.h"
#include <math.h>                   //Funkcja sin()
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//  Konstruktor
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//  Przeksztacenie daty urodzenia w liczb dni ycia.
//  Odczytanie zakresu modelowania biorytmu
void TForm1 ::  inicjuj_parametry( void)
{
 int d = Edit1 -> Text.ToInt();
 int m = Edit2 -> Text.ToInt();
 int r = Edit3 -> Text.ToInt();
 TDateTime data_urodzenia( (unsigned short)r, (unsigned short)m, (unsigned short)d);

 il_dni_zycia = TDateTime().CurrentDate().Val - data_urodzenia.Val;
 zakres = Edit4 -> Text.ToInt() * 7;
}
//---------------------------------------------------------------------------
//  Funkcja odpowiedzialna za grafik okienka
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 inicjuj_parametry();               //liczba dni ycia, zakres
 TDiagram d( 32, 70, 360, 140,
    il_dni_zycia, 0.0, 2.0 * zakres, 2.1, Canvas);

 kresl_bio_linie( 23, d, clRed);    //Sprawno fizyczna
 kresl_bio_linie( 28, d, clGreen);  //Emocje, wybuchowo
 kresl_bio_linie( 33, d, clBlue);   //Aktywno intelektualna
 d.siatka( 7, 1.05);              //Dodatkowa kosmetyka wykresu
}
//---------------------------------------------------------------------------
//  Wykrelenie pojedynczej sinusoidy
void TForm1 :: kresl_bio_linie( int cykl, TDiagram diag, TColor kolor)
{

 int xe_old, ye_old, xe, ye;        //punkt poprzedni i biecy - do odcinka linii wykresu
 bool pierwszy_punkt = true;        //pierwszy odcinek wykresu nie ma punktu poprzedniego

 for( double nr = il_dni_zycia - zakres; nr <= il_dni_zycia + zakres; nr ++)
 {
    xe = diag.daj_ekr_x( nr);
    ye = diag.daj_ekr_y( daj_bio_wartosc( cykl, nr));
    if( pierwszy_punkt)             //Pocztek wykresu? Bez linii
    {
        Canvas -> Pixels[ xe][ ye] = kolor;
        pierwszy_punkt = false;
    }
    else                            //Kontynuacja linii wykresu
    {
        Canvas -> Pen -> Color = kolor;
        Canvas -> MoveTo( xe_old, ye_old);
        Canvas -> LineTo( xe, ye);
    }

    xe_old = xe;
    ye_old = ye;
 }
}
//---------------------------------------------------------------------------
//	Warto sinusoidy o okresie 'cykl' w 'nr' dniu ycia.
//	Funkcja ma minimum (=-1) dla dnia nr=0.
//	Staa M_PI jest zdefiniowana w pliku math.h
double TForm1 :: daj_bio_wartosc( int cykl, double nr)
{
 return sin( 2. * M_PI * nr / (double)cykl - M_PI / 2.);
}
//---------------------------------------------------------------------------
//	Nacinicie przycisku 'Rysuj'
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 Refresh();
}
//---------------------------------------------------------------------------
