//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "widmo.h"
#include <stdlib.h>
//---------------------------------------------------------------------------
//	Konstruktor inicjuje wewntrzny ustrj obiektu.
TWidmo :: TWidmo( void)
{
 int il_czysty_kolor = 15;		//liczba wej do tabeli tecza

 LAMBDA_MIN = 0.35E-6;			//granica nadfioletowa
 LAMBDA_MAX = 0.7E-6;			//granica podczerwona
 Askal = (double)(il_czysty_kolor-1) / (LAMBDA_MAX - LAMBDA_MIN);
 Bskal = -Askal * LAMBDA_MIN;
 Cskal = 4. / 100.;			//skalowanie jasnoci

 tecza[0][0] = 30; tecza[0][1] = 7; tecza[0][2] = 40;
 tecza[1][0] = 40; tecza[1][1] = 10; tecza[1][2] = 50;
 tecza[2][0] = 47; tecza[2][1] = 15; tecza[2][2] = 63;
 tecza[3][0] = 23; tecza[3][1] = 31; tecza[3][2] = 63;
 tecza[4][0] = 0; tecza[4][1] = 40; tecza[4][2] = 63;
 tecza[5][0] = 0; tecza[5][1] = 53; tecza[5][2] = 50;
 tecza[6][0] = 0; tecza[6][1] = 63; tecza[6][2] = 20;
 tecza[7][0] = 31; tecza[7][1] = 63; tecza[7][2] = 0;
 tecza[8][0] = 63; tecza[8][1] = 63; tecza[8][2] = 0;
 tecza[9][0] = 63; tecza[9][1] = 47; tecza[9][2] = 7;
 tecza[10][0] = 63; tecza[10][1] = 31; tecza[10][2] = 15;
 tecza[11][0] = 63; tecza[11][1] = 15; tecza[11][2] = 7;
 tecza[12][0] = 63; tecza[12][1] = 0; tecza[12][2] = 0;
 tecza[13][0] = 51; tecza[13][1] = 0; tecza[13][2] = 0;
 tecza[14][0] = 40; tecza[14][1] = 0; tecza[14][2] = 0;
}
//---------------------------------------------------------
//	Najwaniejsza funkcja, zamieniajca L i jasno w kolor
//	Zaimplementowano pseudolosowe rozmywanie barwy i jasnoci
// na gboko +-1% (patrz zadanie nr 1).
TColor TWidmo :: lambda_to_kolor( int jasnosc, double L)
{
 int pierwszy_kolor, r, g, b;
 double prawdziwy_kolor, ulamek_drugiego, a1, a2;
 double jasn;

 jasnosc += (1 - random( 3));	//patrz zadanie nr 1...
 L += 0.1E-8 * (1.0 - (double)random( 2000) / 1000.0);

 if( L <= LAMBDA_MIN || L >= LAMBDA_MAX)	//poza zakresem widzenia
	return clBlack;

 if( jasnosc > 100)			//zbyt dua jasno
 	jasnosc = 100;
 if( jasnosc < 0)				//zbyt maa jasno
 	jasnosc = 0;

 jasn = Cskal * jasnosc;	    //przeskalowanie jasnoci

 prawdziwy_kolor = Askal * L + Bskal;
 pierwszy_kolor = (int)prawdziwy_kolor;  //cz cakowita, np. 7
 ulamek_drugiego = prawdziwy_kolor - pierwszy_kolor;//uamek 2 koloru, np. 0.35

 a1 = tecza[ pierwszy_kolor][ 0] * jasn;
 a2 = tecza[ pierwszy_kolor + 1][ 0] * jasn;
 r = (int)( a1 + ulamek_drugiego * (a2 - a1));

 a1 = tecza[ pierwszy_kolor][ 1] * jasn;
 a2 = tecza[ pierwszy_kolor + 1][ 1] * jasn;
 g = (int)( a1 + ulamek_drugiego * (a2 - a1));

 a1 = tecza[ pierwszy_kolor][ 2] * jasn;
 a2 = tecza[ pierwszy_kolor + 1][ 2] * jasn;
 b = (int)( a1 + ulamek_drugiego * (a2 - a1));
 return RGB( r, g, b);
}

