//---------------------------------------------------------------------------
//  Obiekt realizujcy uproszczony wykres 3-wymiarowy.

#include <vcl\vcl.h>
#pragma hdrstop

#include "pseudo3d.h"
//---------------------------------------------------------------------------
//	Konstruktor z kompletem parametrw
TWykresPseudo3d :: TWykresPseudo3d( int xe0, int ye0, int eszer, int ewys,
				   double xr0, double yr0, double rszer, double rwys)
{
 for( int k = 0; k < MAX_ESZER; k ++)   //inicjowanie kontroli przesaniania
 {
    doliny[ k] = 100000;                //przenicowana dolina
    gory[ k] = -100000;                 //przenicowana gra
 }

 fxe0 = xe0;                            //obszar ekranowy, udostpniony funkcji iteruj()
 fye0 = ye0;
 feszer = eszer;
 fewys = ewys;

 x0 = xr0 - rszer / 2;                  //pocztek krelenia w poziomie
 y0 = yr0 - rwys  / 2;                  //i w pionie
 dx = rszer / (double)eszer;            //krok krelenia w poziomie
 dy = rwys  / (double)ewys;             //i w pionie
}
//---------------------------------------------------------------------------
//	Opis krelonej pachty funkcyjnej.
//	Uytkownik obiektu TWykresPseudo3d musi przedefiniowa t funkcj,
//	wprowadzajc do gry wasn formu.
double TWykresPseudo3d :: fun( double x, double y)
{
 return 0;
}
//---------------------------------------------------------------------------
//	zapocztkowanie procesu przegldania obszaru funkcji
void TWykresPseudo3d :: inicjuj_iterator( void)
{
 i = j = 0;                             //start dla funkcji iterator()
}
//---------------------------------------------------------------------------
//	Gdy true, dostarcza punktw do krelenia wykresw.
//	false - koniec krelenia.
bool TWykresPseudo3d :: iterator( int &xe1, int &ye1, int &xe2, int &ye2)
{
 int xe, ye;                            //roboczy punkt na ekranie
 double x, y, f;
 bool znaleziono = false;               //czy znaleziono punkt?
 bool kontynuacja_linii;                //czy mona czy lini poprzedni punkt z biecym?

 kontynuacja_linii = j == 0 ? false : true;//kontynuujemy wczeniej zaczt lini? Zaczynamy now?

 while( i < fewys)                      //kontynuuj, gdy nie koniec wykresu
 {
    y = y0 + (double)i * dy;            //wsprzdna w przestrzeni matematycznej

    while( j < feszer)                  //kontynuuj, nie koniec linii w poziomie
    {
        x = x0 + (double)j * dx;        //wsprzdna w przestrzeni matematycznej

        f = fun( x, y);                 //pobranie wartoci funkcji

        xe = j + i;                     //wyliczenie ekranowych wsprzdnych punktu wykresu
        ye = i + f;

        if( ye < doliny[ xe])           //dolina nisza ni jakakolwiek?
            doliny[ xe] = ye;           //zmodyfikuj doln krawd obszaru przesaniania

        if( ye > gory[ xe])             //gra wysza ni jakakolwiek?
            gory[ xe] = ye;             //zmodyfikuj grn krawd obszaru przesaniania

        if( ye <= doliny[ xe] || ye >= gory[ xe])//czy punkt wida?
            znaleziono = true;          //ptle zakocz dziaanie
        else
            kontynuacja_linii = false;  //zamanie cigoci linii

        j ++;

        if( znaleziono)
        {
            if( kontynuacja_linii)
            {
                xe1 = fxe0 + xeold;     //z poprzedniego wejcia do niniejszej funkcji
                ye1 = (fye0 + fewys) - yeold;
            }
            else
            {
                xe1 = fxe0 + xe;        //bez kontynuacji linii: punkt poprzedni = biecy
                ye1 = (fye0 + fewys) - ye;
            }
            xeold = xe;                 //przechowanie dla nastpnego wywoania niniejszej funkcji
            yeold = ye;
            xe2 = fxe0 + xe;            //udostpnienie biecego punktu (referencja!)
            ye2 = (fye0 + fewys) - ye;

            return true;
        }
    }
    if( j >= feszer)
        j = 0;
    i ++;
    kontynuacja_linii = false;          //nowa linia
 }
 return false;                          //koniec przegldania obszaru wykresu
}
//---------------------------------------------------------------------------
