<?php get_header(); ?>
    <div id="inner-site">
        <div id="content" class="entry-list">
            <ul id="above-listings">
            <?php dynamic_sidebar('listings'); ?>
            </ul>
            <div id="section-head">
                <p><?php _e('I\'m a published author, and these are my books. Just the English ones though, no Swedish works here I\'m afraid.', 'tdh7');?></p>
            </div>
            <?php 
                // Podstawowa pętla
                while ( have_posts() ) : the_post(); ?>

                <div id="post-<?php the_ID(); ?>" <?php post_class('books-archive'); ?>>
                    <div class="books-cover">
                        <a href="<?php the_permalink(); ?>" class="books-cover-link">
                        <?php 
                            // Czy wpis ma ikonę?
                            if ( has_post_thumbnail() ) { 
                                // Tak, więc jej użyjemy
                                the_post_thumbnail( 'books-small' ); 
                            } 
                            // Nie, więc użyjemy domyślnej
                            else { ?>
                                <img src="<?php echo 
                                get_template_directory_uri(); ?>/img/books-nocoveryet.png" width="150" height="190" alt="Brak okładki" />
                            <?php }
                            // Wszystko zrobione
                        ?>
                        </a>
                    </div>
                    <div class="books-content">
                        <h2 class="entry-title books-title">
                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">
                                <?php the_title(); ?>
                            </a>
                        </h2>
                        <div class="entry-summary entry-summary-books">
                            <?php the_excerpt(); ?>
                        </div>
                    </div>
                </div>

            <?php 
                // Koniec pętli
                endwhile; ?>
        </div>
        <?php 
            // Prawa kolumna
            get_sidebar();

            // Jeśli to możliwe, wyświetlamy nawigację na dole
            if ( $wp_query->max_num_pages > 1 ) :
        ?>
            <div class="navigate">
                <div class="nav-left">
                    <?php
                        next_posts_link(__ ('&larr; Browse older content', 'tdh7') ); 
                    ?>
                </div>
                <div class="nav-right">
                    <?php 
                        previous_posts_link(__ ('Browse more recent content &rarr;', 'tdh7') ); 
                    ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

<?php get_footer(); ?>