'use strict';

const util  = require('util');
const path  = require('path');

const log   = require('debug')('notes:router-users');
const error = require('debug')('notes:error');

const express  = require('express');
const router   = express.Router();

exports.router = router;

const passport = require('passport');
const LocalStrategy = require('passport-local').Strategy;
const TwitterStrategy = require('passport-twitter').Strategy;

const usersModel = require(process.env.USERS_MODEL ? path.join('..', process.env.USERS_MODEL) : '../models/users-rest');

exports.initPassport = function(app) {
  app.use(passport.initialize());
  app.use(passport.session());
};

exports.ensureAuthenticated = function(req, res, next) {
  // Obiekt req.user jest ustawiany przez narzędzie Passport w funkcji deserialize 
  if (req.user) next();
  else res.redirect('/users/login');
};


router.get('/login', function(req, res, next) {
  // log(util.inspect(req));
  res.render('login', {
    title: "Logowanie do aplikacji Notes",
    user: req.user,
    // message: req.flash('error')
  });
});

router.post('/login',
  passport.authenticate('local', {
    successRedirect: '/',              // POWODZENIE: przejście do strony głównej
    failureRedirect: 'login', // NIEPOWODZENIE: przejście do strony /user/login
    // failureFlash: true
  })
);

/* NIEUŻYWANE
router.get('/login/fail', function(req, res, next) {
  res.send('Błąd uwierzytelniania');
});

router.get('/login/success', function(req, res, next) {
  res.send('Udane uwierzytelnianie');
}); */

router.get('/logout', function(req, res, next) {
  req.logout();
  res.redirect('/');
});

// Przekierowanie użytkownika do Twittera w celu uwierzytelnienia. Po zakończeniu tej operacji
// Twitter kieruje użytkownika z powrotem do aplikacji pod adres
//   /auth/twitter/callback
router.get('/auth/twitter', passport.authenticate('twitter'));

// Twitter przekierowuje użytkownika pod ten adres po udanym uwierzytelnieniu. Należy
// zakończyć proces uwierzytelniania, próbując uzyskać token dostępu. Po przyznaniu dostępu
// użytkownik będzie zalogowany. W przeciwnym razie uwierzytelnianie kończy się niepowodzeniem.
router.get('/auth/twitter/callback',
  passport.authenticate('twitter', { successRedirect: '/',
                                     failureRedirect: '/users/login' }));

passport.use(new LocalStrategy(
  function(username, password, done) {
    log('pasport use username='+ username +' '+ password);
    usersModel.userPasswordCheck(username, password)
    .then(check => {
      if (check.check) {
        done(null, { id: check.username, username: check.username });
      } else {
        done(null, false, check.message);
      }
      return check;
    })
    .catch(err => { error('LocalStrategy '+ err.stack); done(err); });
  }
));

passport.use(new TwitterStrategy({
    consumerKey: "V5oBDLJOGsC7QztZlRqAk8sI4",
    consumerSecret: "0Vc1HHUEY3a4YYYfNJDFHPOiljruKMTiecHYyAufxN2Mc0Gxbm",
    callbackURL: "http://MacBook-Pro-2.local:3000/users/auth/twitter/callback"
  },
  function(token, tokenSecret, profile, done) {
    log('TwitterStrategy '+ util.log(profile));
    usersModel.findOrCreate({
      id: profile.username, username: profile.username, password: "", provider: profile.provider,
      familyName: profile.displayName, givenName: "", middleName: "",
      photos: profile.photos, emails: profile.emails
    })
    .then(user => done(null, user))
    .catch(err => { error('TwitterStrategy '+ err.stack); done(err); });
  }
));

passport.serializeUser(function(user, done) {
  log('serializeUser '+ util.inspect(user));
  done(undefined, user.username);
});

passport.deserializeUser(function(username, done) {
  log('deserializeUser '+ username);
  usersModel.find(username)
  .then(user => {
    log('... znaleziono użytkownika '+ util.inspect(user));
    done(null, user);
  })
  .catch(err => { error('deserializeUser '+ err.stack); done(err); });
});
