
const Sequelize = require("sequelize");
const jsyaml    = require('js-yaml');
const fs        = require('fs');
const util      = require('util');

const log   = require('debug')('notes:model-users');
const error = require('debug')('notes:error');

var SQUser;
var sequlz;

exports.connectDB = function() {
    
    if (SQUser) return SQUser.sync();
    
    return new Promise((resolve, reject) => {
        fs.readFile(process.env.SEQUELIZE_CONNECT, 'utf8', (err, data) => {
            if (err) reject(err);
            else resolve(data);
        });
    })
    .then(yamltext => {
        return jsyaml.safeLoad(yamltext, 'utf8');
    })
    .then(params => {
        sequlz = new Sequelize(params.dbname, params.username, params.password, params.params);
        
        // Te pola pochodzą głównie ze schematu Portable Contacts z narzędzia Passport
        // Zobacz http://www.passportjs.org/docs/profile
        //
        // Pola emails i photos w schemacie Portable Contacts to tablice. Wymagają utworzenia 
        // dodatkowych tabel.
        //
        // Pole "id" ze schematu Portable Contacts to pole "username" w tym kodzie
        SQUser = sequlz.define('User', {
            username: { type: Sequelize.STRING, unique: true },
            password: Sequelize.STRING,
            provider: Sequelize.STRING,
            familyName: Sequelize.STRING,
            givenName: Sequelize.STRING,
            middleName: Sequelize.STRING,
            emails: Sequelize.STRING(2048),
            photos: Sequelize.STRING(2048)
        });
        return SQUser.sync();
    });
};

exports.create = function(username, password, provider, familyName, givenName, middleName, emails, photos) {
    return exports.connectDB()
    .then(SQUser => {
        return SQUser.create({
            username: username,
            password: password,
            provider: provider,
            familyName: familyName,
            givenName: givenName,
            middleName: middleName,
            emails: JSON.stringify(emails),
            photos: JSON.stringify(photos)
        });
    });
};

exports.update = function(username, password, provider, familyName, givenName, middleName, emails, photos) {
    return exports.find(username)
    .then(user => {
        return user ? user.updateAttributes({
            password: password,
            provider: provider,
            familyName: familyName,
            givenName: givenName,
            middleName: middleName,
            emails: JSON.stringify(emails),
            photos: JSON.stringify(photos)
        }) : undefined;
    });
};

exports.find = function(username) {
    log('find  '+ username);
    return exports.connectDB()
    .then(SQUser => {
        return SQUser.find({ where: { username: username } })
    });
};

exports.userPasswordCheck = function(username, password) {
    return exports.find(username)
    .then(user => {
        log('userPasswordCheck '+ username +' '+ password +' '+ util.inspect(user));
        if (!user) {
            return { check: false, username: username, message: "Nie można znaleźć użytkownika" };
        } else if (user.username === username && user.password === password) {
            return { check: true, username: user.username };
        } else {
            return { check: false, username: username, message: "Błędne hasło" };
        }
    });
};

exports.findOrCreate = function(profile) {
    return exports.find(profile.username)
    .then(user => {
        if (user) return user;
        // else
        return exports.create(profile.id, null, profile.provider,
                       profile.name.familyName, profile.name.givenName, profile.name.middleName,
                       profile.emails, profile.photos);
    });
    
};

exports.listUsers = function() {
    return exports.connectDB()
    .then(SQUser => SQUser.findAll({}) )
    .then(userlist => {
        userlist.forEach(user => { console.log(util.inspect(user)); })
    })
    .catch(err => console.error(err));
    
}
