<%@ Page
    Language="C#"
    CodeFile="Typical.aspx.cs"
    Inherits="AjaxControlToolkit.Testing.Client.ResizableControl.Typical" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>ResizableControl - Typical</title>
    <style type="text/css">
        .resizeHandle
        {
            width:20px;
            height:30px;
            background-color:Lime;
            overflow:hidden;
        }
        .resizeStyle
        {
            padding:0px;
            border-style:solid;
            border-width:2px;
            border-color:Fuchsia;
            overflow:hidden;
        }
    </style>
</head>
<body><form id="form" runat="server"><div>
    <b>ResizableControl - Typical</b><br />
    Typical ResizableControl scenarios<br /><br /><br />

    <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />

    <asp:Panel ID="Panel1" runat="server" Width="100" Height="100" BackColor="LightSteelBlue" style="overflow:hidden">
        <asp:Panel ID="Panel2" runat="server" style="width:100%; height:100%; overflow:hidden">
            This is some content for the resizable part of the page.
        </asp:Panel>
    </asp:Panel>

    <ajaxToolkit:ResizableControlExtender ID="ResizableControlExtender" runat="server" TargetControlID="Panel1" HandleCssClass="resizeHandle" ResizableCssClass="resizeStyle"
        HandleOffsetX="10" HandleOffsetY="-5" MinimumWidth="40" MinimumHeight="50" MaximumWidth="300" MaximumHeight="400"
        OnClientResize="OnClientResize" OnClientResizing="OnClientResizing" OnClientResizeBegin="OnClientResizeBegin" />

    <br />
    <br />

    <asp:Button ID="Button" runat="server" Text = "Postback" OnClick="Button_Click" />

    <br />
    <br />

    <asp:Label ID="Label" runat="server" Text="-" />

    <script type="text/javascript">
        var resizeFired = false;
        function OnClientResize() {
            resizeFired = true;
        }

        var resizingFired = false;
        function OnClientResizing() {
            resizingFired = true;
        }

        var resizeBeginFired = false;
        function OnClientResizeBegin() {
            resizeBeginFired = true;
        }
    </script>

</div></form></body>
</html>
