<%@ Page Language="C#" CodeFile="Date.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.MaskedEdit.Date" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>MaskedEdit - Date</title>
</head>
<body>
    <form id="form" runat="server">
        <div>
            <b>MaskedEdit - Date</b><br />
            Ensure that masked edit extender works fine if the mask type is set to Date<br />
            <br />
            <br />
            <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
            Date TextBox
            <asp:TextBox runat="Server" ID="DateTextBox"></asp:TextBox>
            <ajaxToolkit:MaskedEditExtender runat="server" TargetControlID="DateTextBox" ID="DateTextBoxMaskedEditExtender"
                MaskType="Date" Mask="99/99/9999">
            </ajaxToolkit:MaskedEditExtender>
            <ajaxToolkit:MaskedEditValidator runat="server" ID="DateValidator" ControlExtender="DateTextBoxMaskedEditExtender"
                ControlToValidate="DateTextBox" EmptyValueMessage="Please enter a date" InvalidValueMessage="Invalid date"
                IsValidEmpty="false" MinimumValue="01/01/1900" MaximumValue="12/12/2999" MaximumValueMessage="Date too far out"
                MinimumValueMessage="Date too early"></ajaxToolkit:MaskedEditValidator>
            <br />
            <br />
            MaskType: Date, mask: 99/99/9999
            <br />
            <asp:TextBox ID="AutoCompleteDateTextBox" runat="server" ValidationGroup="Demo1"
                Width="328px"></asp:TextBox><br />
            <ajaxToolkit:MaskedEditExtender ID="AutoCompleteDateMaskedEditExtender" runat="server"
                AcceptNegative="Left" DisplayMoney="Left" Mask="99/99/9999" MaskType="Date" MessageValidatorTip="true"
                OnFocusCssClass="MaskedEditFocus" OnInvalidCssClass="MaskedEditError" TargetControlID="AutoCompleteDateTextBox"
                CultureName="en-US" AutoComplete="true" AutoCompleteValue="05/23/1964">
            </ajaxToolkit:MaskedEditExtender>
            <ajaxToolkit:MaskedEditValidator ID="AutoCompleteMaskedEditValidator" runat="server"
                ControlExtender="AutoCompleteDateMaskedEditExtender" ControlToValidate="AutoCompleteDateTextBox"
                Display="Dynamic" IsValidEmpty="False" MaximumValue="01/01/2010" EmptyValueMessage="Date is required"
                InvalidValueMessage="Date is invalid" MaximumValueMessage="Message Max" MinimumValueMessage="Message Min"
                TooltipMessage="Input a Date" MinimumValue="02/02/1900" ValidationGroup="Demo1"></ajaxToolkit:MaskedEditValidator>
        </div>
    </form>
</body>
</html>
