// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ToggleButton;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>ToggleButton\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.ToggleButtonBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ToggleButton.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ToggleButton.Sample")]
[WebTestTag("SampleWebSite")]
public class ToggleButton_Sample : AjaxControlToolkit.Testing.Client.ToggleButton.ToggleButton_Common
{
    public override IEnumerable<ToggleButtonBehavior> ToggleButtons
    {
        get 
        {
            SamplePage page = new SamplePage();
            yield return page.ToggleButtonExtender1;
            yield return page.ToggleButtonExtender2;
        }
    }
}