// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.TextBoxWrapper;

/// <summary>
/// TextBoxWrapper integration with FilteredTextBox
/// </summary>
/// <TestSuite>
///   <Path>TextBoxWrapper\FilteredTextBox.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.TextBoxWrapperBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.TextBoxWrapper.FilteredTextBoxPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("TextBoxWrapper.FilteredTextBox")]
public class TextBoxWrapper_FilteredTextBox : AjaxControlToolkit.Testing.Client.TextBoxWrapper.TextBoxWrapper_Common
{
    [WebTestMethod]
    public void Interop()
    {
        FilteredTextBoxPage page = new FilteredTextBoxPage();

        Assert.AreEqual(page.TextBoxWatermarkExtender.WatermarkText.Value, page.TextBox.GetAttributes().Value);
        page.TextBox.SetText("Anything", true);
        page.TextBox.SetText("", true);
        Assert.AreEqual(page.TextBoxWatermarkExtender.WatermarkText.Value, page.TextBox.GetAttributes().Value);
    }
}
