// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.ReorderList;

/// <summary>
/// ReorderList bounds to an IListDataSource
/// </summary>
/// <TestSuite>
///   <Path>ReorderList\IListDataSource.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropWatcherBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.ReorderList.IListDataSourcePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("ReorderList.IListDataSource")]
public class ReorderList_IListDataSource : ReorderList_Common
{
    /// <summary>
    /// ReorderLists on the page
    /// </summary>
    public override IEnumerable<DropWatcherBehavior> ReorderLists
    {
        get { yield return new IListDataSourcePage().ReorderList; }
    }
}