// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;

namespace AjaxControlToolkit.Testing.Client.PasswordStrength
{
    /// <summary>
    /// Common PasswordStrength tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.PasswordStrengthBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("PasswordStrength")]
    public abstract class PasswordStrength_Common
    {
        public abstract IEnumerable<PasswordStrengthBehavior> PasswordStrengths
        {
            get;
        }

        [WebTestMethod]
        [WebTestFailureTag(Browsers.Opera, "SendKeys does not work in Opera")]
        [WebTestFailureTag(Browsers.Safari, "Safari doesn't seem to support DispatchEvent of a KeyboardEvent")]
        public void Common_SetPasswordAndIndicatorVisibility()
        {
            string shortPassword = "Foo";
            string longPassword = "@JAXC0ntrolToolkit!$$R0cks!";
            foreach (PasswordStrengthBehavior passwordStrength in PasswordStrengths)
            {
                // set password to insufficient chars
                passwordStrength.SetPassword(shortPassword);
                passwordStrength.AssertIndicatorVisibility(Visibility.Visible);
                passwordStrength.Element.Blur();
                passwordStrength.AssertIndicatorVisibility(Visibility.Hidden);
                passwordStrength.ClearPassword();

                // set password to long password
                passwordStrength.SetPassword(longPassword);
                passwordStrength.AssertIndicatorVisibility(Visibility.Visible);
                passwordStrength.Element.Blur();
                passwordStrength.AssertIndicatorVisibility(Visibility.Hidden);
                passwordStrength.ClearPassword();

                // set password on readonlybox
                passwordStrength.Page.ExecuteScript(
                        string.Format("$get('{0}').readOnly=true", passwordStrength.Element.Id));
                passwordStrength.SetPassword(shortPassword);
                passwordStrength.AssertIndicatorVisibility(Visibility.Hidden);
                passwordStrength.Element.Blur();
                passwordStrength.AssertIndicatorVisibility(Visibility.Hidden);
                passwordStrength.ClearPassword();
            }
        }

    }
}