// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.PasswordStrength;

/// <summary>
/// Test to make sure that the bar shows up when a password is entered into the textbox
/// </summary>
/// <TestSuite>
///   <Path>PasswordStrength\BarIndicatorValidInvalidPassword.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.PasswordStrengthBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.PasswordStrength.BarIndicatorValidInvalidPasswordPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("PasswordStrength.BarIndicatorValidInvalidPassword")]
public class PasswordStrength_BarIndicatorValidInvalidPassword : AjaxControlToolkit.Testing.Client.PasswordStrength.PasswordStrength_Common
{
    public override IEnumerable<PasswordStrengthBehavior> PasswordStrengths
    {
        get 
        {
            yield return new BarIndicatorValidInvalidPasswordPage().p2;
        }
    }

}