// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DynamicPopulate;

/// <summary>
/// Simple DynamicPopulate custom script test
/// </summary>
/// <TestSuite>
///   <Path>DynamicPopulate\CustomScript.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DynamicPopulateBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DynamicPopulate.CustomScriptPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DynamicPopulate.CustomScript")]
public class DynamicPopulate_CustomScript : AjaxControlToolkit.Testing.Client.DynamicPopulate.DynamicPopulate_Common
{
    public override IEnumerable<Tuple<DynamicPopulateBehavior, string>> DynamicPopulation
    {
        get { yield return new Tuple<DynamicPopulateBehavior, string>(new CustomScriptPage().DynamicPopulate, DynamicContent); }
    }
}