// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// Ensure that if key value pairs are returned by the webservice, AutoComplete 
/// deserializes it just fine.
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\TextValuePair.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.TextValuePairPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.TextValuePair")]
public class AutoComplete_TextValuePair : AjaxControlToolkit.Testing.Client.AutoComplete.AutoComplete_Common
{
    public override IEnumerable<AutoCompleteBehavior> AutoCompletes
    {
        get
        {
            yield return new TextValuePairPage().AutoCompleteExtender3;
        }
    }

    /// <summary>
    /// Make sure that the value in the textbox is set to the value returned by
    /// the webservice as a part of the text/value pair.
    /// </summary>
    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: Fix the way keyboard events are being simulated.")]
    public void ValueInTextBox()
    {
        TextValuePairPage page = new TextValuePairPage();
        page.AutoCompleteExtender3.SetTextWaitForFlyout("foo");
        page.AutoCompleteExtender3.ChooseOption(4);
        Assert.AreEqual("4", page.TextBox3.GetAttributes().Value.Trim());
    }
}