// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AutoComplete;

/// <summary>
/// Test that validates that delimiters set on an autocompleteextender allow users to complete the last word typed instead of the entire text in the textbox.
/// </summary>
/// <TestSuite>
///   <Path>AutoComplete\MultiWordTest.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AutoCompleteBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AutoComplete.MultiWordTestPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AutoComplete.MultiWordTest")]
public class AutoComplete_MultiWordTest : AjaxControlToolkit.Testing.Client.AutoComplete.AutoComplete_Common
{
    public override IEnumerable<AutoCompleteBehavior> AutoCompletes
    {
        get 
        {
            yield return new MultiWordTestPage().AutoCompleteExtender2;
        }
    }

    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera | Browsers.Safari, "TODO: Fix the way keyboard events are being simulated.")]
    public void MutlipleWords()
    {
        string testString = "abc;foo bar";
        MultiWordTestPage page = new MultiWordTestPage();
        page.AutoCompleteExtender2.SetTextWaitForFlyout(testString);
        string result = page.AutoCompleteExtender2.GetCurrentWordToComplete();
        Assert.AreEqual("bar", result);
        page.AutoCompleteExtender2.ChooseOption(3);
        string resultInTextBox = page.AutoCompleteExtender2.TextBoxValue;
        Assert.IsTrue(resultInTextBox.StartsWith(testString));
        Assert.IsTrue(resultInTextBox.Length > testString.Length);
    }
}