// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.Animation;

/// <summary>
/// Basic animation tests
/// </summary>
/// <TestSuite>
///   <Path>Animation\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AnimationBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.Animation.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("Animation.Simple")]
public class Animation_Simple : Animation_Common
{
    [WebTestMethod]
    [WebTestTag("Smoke")]
    public void Play()
    {
        SimplePage page = new SimplePage();

        page.Animations.OnLoad.Ended.Register();
        page.Animations.OnLoad.Ended.Wait(1, false);
        Assert.AreEqual("OnLoad", page.Target.GetAttributes().Value);

        page.Animations.OnClick.Ended.Register();
        page.Target.Click();
        page.Animations.OnClick.Ended.Wait(1);
        Assert.AreEqual("OnClick", page.Target.GetAttributes().Value);

        page.Animations.OnMouseOver.Ended.Register();
        page.Animations.OnMouseOver.Play();
        page.Animations.OnMouseOver.Ended.Wait(1);
        Assert.AreEqual("OnMouseOver", page.Target.GetAttributes().Value);

        page.Animations.OnMouseOut.Ended.Register();
        page.Animations.OnMouseOut.Play();
        page.Animations.OnMouseOut.Ended.Wait(1);
        Assert.AreEqual("OnMouseOut", page.Target.GetAttributes().Value);

        page.Animations.OnHoverOver.Ended.Register();
        page.Animations.OnHoverOver.Play();
        page.Animations.OnHoverOver.Ended.Wait(1);
        Assert.AreEqual("OnHoverOver", page.Target.GetAttributes().Value);

        page.Animations.OnHoverOut.Ended.Register();
        page.Animations.OnHoverOut.Play();
        page.Animations.OnHoverOut.Ended.Wait(1);
        Assert.AreEqual("OnHoverOut", page.Target.GetAttributes().Value);
    }
}