// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.SlideShow
{
    /// <summary>
    /// Ensure that updating the context key resets the SlideShow correctly.
    /// </summary>
    public partial class ContextKey : Page
    {
        [System.Web.Services.WebMethod]
        [System.Web.Script.Services.ScriptMethod]
        public static AjaxControlToolkit.Slide[] GetSlidesWithContext(string contextKey)
        {
            if (contextKey == "Venice")
            {
                return new AjaxControlToolkit.Slide[] { 
                new AjaxControlToolkit.Slide("images/Venice1.jpg", contextKey, ""),
                new AjaxControlToolkit.Slide("images/Venice2.jpg", contextKey, ""),
                new AjaxControlToolkit.Slide("images/Venice3.jpg", contextKey, "")};
            }
            else if (contextKey == "Positano")
            {
                return new AjaxControlToolkit.Slide[] { 
                new AjaxControlToolkit.Slide("images/Positano1.jpg", contextKey, ""),
                new AjaxControlToolkit.Slide("images/Positano2.jpg", contextKey, "")};
            }
            else if (contextKey == "Capri")
            {
                return new AjaxControlToolkit.Slide[] { 
                new AjaxControlToolkit.Slide("images/Capri1.jpg", contextKey, ""),
                new AjaxControlToolkit.Slide("images/Capri2.jpg", contextKey, ""),
                new AjaxControlToolkit.Slide("images/Capri3.jpg", contextKey, ""),
                new AjaxControlToolkit.Slide("images/Capri4.jpg", contextKey, "")};
            }
            return null;
        }
    }
}