// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;
using AjaxControlToolkit.Testing.Client;

namespace AjaxControlToolkit.Testing.Client.ReorderList
{
    /// <summary>
    /// ReorderList bound to a DataTable
    /// </summary>
    public partial class DataTable : Page
    {
        /// <summary>
        /// Table to bind to
        /// </summary>
        protected System.Data.DataTable Table
        {
            get
            {
                if (_table == null)
                {
                    _table = ViewState["DataTable"] as System.Data.DataTable;
                    if (_table == null)
                    {
                        _table = new System.Data.DataTable();
                        DataColumn idColumn = new DataColumn("ID", typeof(int));
                        _table.Columns.Add(idColumn);
                        _table.Columns.Add("Name", typeof(string));
                        _table.Columns.Add("Sort", typeof(int));
                        _table.Constraints.Add("pk", idColumn, true);

                        _table.Rows.Add(1, "Shawn", 0);
                        _table.Rows.Add(2, "David", 1);
                        _table.Rows.Add(3, "Ted", 2);
                        _table.Rows.Add(4, "Kirti", 3);
                        _table.Rows.Add(5, "Red", 4);
                        _table.Rows.Add(6, "Blue", 5);
                        _table.Rows.Add(7, "Green", 6);
                        ViewState["DataTable"] = _table;
                    }
                }
                return _table;
            }
        }
        private System.Data.DataTable _table;

        /// <summary>
        /// Bind the data source
        /// </summary>
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            if (!IsPostBack)
            {
                DataView view = Table.DefaultView;
                view.Sort = "Sort ASC";
                List.DataSource = view;
                List.DataBind();
            }
        }
    }
}