<%@ Page Language="C#" CodeFile="Sample.aspx.cs" Inherits="AjaxControlToolkit.Testing.Client.ModalPopup.Sample" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>ModalPopup - Sample</title>
    <link href="../StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form" runat="server">
        <div>
            <b>ModalPopup - Sample</b><br />
            SampleWebSite scenario<br />
            <br />
            <br />

            <script type="text/javascript">
            var styleToSelect;
            function onOk() {
                $get('Paragraph1').className = styleToSelect;
            }
            
            // Add click handlers for buttons to show and hide modal popup on pageLoad
            function pageLoad() {
                $addHandler($get("showModalPopupClientButton"), 'click', showModalPopupViaClient);
                $addHandler($get("hideModalPopupViaClientButton"), 'click', hideModalPopupViaClient);        
            }
            
            function showModalPopupViaClient(ev) {
                ev.preventDefault();
                var modalPopupBehavior = $find('programmaticModalPopupBehavior');
                modalPopupBehavior.show();
            }
            
            function hideModalPopupViaClient(ev) {
                ev.preventDefault();        
                var modalPopupBehavior = $find('programmaticModalPopupBehavior');
                modalPopupBehavior.hide();
            }
            </script>

            <div>
                <b>ModalPopup - ModalPopup_Sample</b><br />
                SampleWebSite scenario<br />
                <br />
                <br />
                <ajaxToolkit:ToolkitScriptManager ID="ScriptManager" runat="server" />
                <p id="Paragraph1">
                    <%= SampleWebSite.GetContentFillerText()%>
                </p>
                <br />
                <asp:LinkButton ID="LinkButton1" runat="server" Text="Click here to change the paragraph style" />
                <asp:Panel ID="Panel1" runat="server" Style="display: none" CssClass="modalPopup">
                    <asp:Panel ID="Panel3" runat="server" Style="cursor: move; background-color: #DDDDDD;
                        border: solid 1px Gray; color: Black">
                        <div>
                            <p>
                                Choose the paragraph style you would like:</p>
                        </div>
                    </asp:Panel>
                    <div>
                        <p>
                            <input type="radio" name="Radio" id="RadioA" checked="checked" onclick="styleToSelect = 'sampleStyleA';" />
                            <label for="RadioA" class="sampleStyleA" style="padding: 3px;">
                                Sample paragraph text</label>
                        </p>
                        <p>
                            <input type="radio" name="Radio" id="RadioB" onclick="styleToSelect = 'sampleStyleB';" />
                            <label for="RadioB" class="sampleStyleB" style="padding: 3px;">
                                Sample paragraph text</label>
                        </p>
                        <p>
                            <input type="radio" name="Radio" id="RadioC" onclick="styleToSelect = 'sampleStyleC';" />
                            <label for="RadioC" class="sampleStyleC" style="padding: 3px;">
                                Sample paragraph text</label>
                        </p>
                        <p>
                            <input type="radio" name="Radio" id="RadioD" onclick="styleToSelect = 'sampleStyleD';" />
                            <label for="RadioD" class="sampleStyleD" style="padding: 3px;">
                                Sample paragraph text</label>
                        </p>
                        <p style="text-align: center;">
                            <asp:Button ID="OkButton" runat="server" Text="OK" />
                            <asp:Button ID="CancelButton" runat="server" Text="Cancel" />
                        </p>
                    </div>
                </asp:Panel>
                <ajaxToolkit:ModalPopupExtender ID="ModalPopupExtender" runat="server" TargetControlID="LinkButton1"
                    PopupControlID="Panel1" BackgroundCssClass="modalBackground" OkControlID="OkButton"
                    OnOkScript="onOk()" CancelControlID="CancelButton" DropShadow="true" PopupDragHandleControlID="Panel3" />
                <br />
                <br />
                <hr />
                <br />
                This ModalPopup will be spawned programmatically. The ModalPopupExtender that this
                popup is attached to has a hidden TargetControl. The popup can be
                <asp:LinkButton runat="server" ID="showModalPopupServerOperatorButton" Text="shown via server in code behind"
                    OnClick="showModalPopupServerOperatorButton_Click" />
                and <a id="showModalPopupClientButton" href="#">on the client in script</a> by calling
                the ModalPopupExtender methods to show and hide.<br />
                <asp:Button runat="server" ID="hiddenTargetControlForModalPopup" Style="display: none" />
                <ajaxToolkit:ModalPopupExtender runat="server" ID="programmaticModalPopup" BehaviorID="programmaticModalPopupBehavior"
                    TargetControlID="hiddenTargetControlForModalPopup" PopupControlID="programmaticPopup"
                    BackgroundCssClass="modalBackground" DropShadow="True" PopupDragHandleControlID="programmaticPopupDragHandle"
                    RepositionMode="RepositionOnWindowScroll">
                </ajaxToolkit:ModalPopupExtender>
                <asp:Panel runat="server" CssClass="modalPopup" ID="programmaticPopup" Style="display: none;
                    width: 350px; padding: 10px">
                    <asp:Panel runat="Server" ID="programmaticPopupDragHandle" Style="cursor: move; background-color: #DDDDDD;
                        border: solid 1px Gray; color: Black; text-align: center;">
                        ModalPopup shown and hidden in code
                    </asp:Panel>
                    You can now use this sample to see how to use ModalPopup with an invisible TargetControl.
                    The ModalPopupExtender this popup is attached to has a hidden target control. The
                    popup is hidden
                    <asp:LinkButton runat="server" ID="hideModalPopupViaServer" Text="on the server side in code behind"
                        OnClick="hideModalPopupViaServer_Click" />
                    and <a id="hideModalPopupViaClientButton" href="#">on the client in script</a>.
                    <br />
                </asp:Panel>
            </div>
        </div>
    </form>
</body>
</html>
