// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections;
using System.Collections.Generic;

namespace AjaxControlToolkit.Testing.Client
{
    public class Tuple<A, B> : IEnumerable<object>
    {
        protected A _first;
        public A First
        {
            get { return _first; }
            set { _first = value; }
        }

        protected B _second;
        public B Second
        {
            get { return _second; }
            set { _second = value; }
        }

        public Tuple()
            : this(default(A), default(B))
        {
        }

        public Tuple(A first, B second)
        {
            _first = first;
            _second = second;
        }

        public virtual IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
    }

    public class Tuple<A, B, C> : Tuple<A, B>
    {
        protected C _third;
        public C Third
        {
            get { return _third; }
            set { _third = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C))
        {
        }

        public Tuple(A first, B second, C third)
            : base(first, second)
        {
            _third = third;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
        }
    }

    public class Tuple<A, B, C, D> : Tuple<A, B, C>
    {
        protected D _fourth;
        public D Fourth
        {
            get { return _fourth; }
            set { _fourth = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D))
        {
        }

        public Tuple(A first, B second, C third, D fourth)
            : base(first, second, third)
        {
            _fourth = fourth;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
        }
    }

    public class Tuple<A, B, C, D, E> : Tuple<A, B, C, D>
    {
        protected E _fifth;
        public E Fifth
        {
            get { return _fifth; }
            set { _fifth = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D), default(E))
        {
        }

        public Tuple(A first, B second, C third, D fourth, E fifth)
            : base(first, second, third, fourth)
        {
            _fifth = fifth;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
            yield return _fifth;
        }
    }

    public class Tuple<A, B, C, D, E, F> : Tuple<A, B, C, D, E>
    {
        protected F _sixth;
        public F Sixth
        {
            get { return _sixth; }
            set { _sixth = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D), default(E), default(F))
        {
        }

        public Tuple(A first, B second, C third, D fourth, E fifth, F sixth)
            : base(first, second, third, fourth, fifth)
        {
            _sixth = sixth;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
            yield return _fifth;
            yield return _sixth;
        }
    }

    public class Tuple<A, B, C, D, E, F, G> : Tuple<A, B, C, D, E, F>
    {
        protected G _seventh;
        public G Seventh
        {
            get { return _seventh; }
            set { _seventh = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D), default(E), default(F), default(G))
        {
        }

        public Tuple(A first, B second, C third, D fourth, E fifth, F sixth, G seventh)
            : base(first, second, third, fourth, fifth, sixth)
        {
            _seventh = seventh;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
            yield return _fifth;
            yield return _sixth;
            yield return _seventh;
        }
    }

    public class Tuple<A, B, C, D, E, F, G, H> : Tuple<A, B, C, D, E, F, G>
    {
        protected H _eigth;
        public H Eigth
        {
            get { return _eigth; }
            set { _eigth = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D), default(E), default(F), default(G), default(H))
        {
        }

        public Tuple(A first, B second, C third, D fourth, E fifth, F sixth, G seventh, H eigth)
            : base(first, second, third, fourth, fifth, sixth, seventh)
        {
            _eigth = eigth;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
            yield return _fifth;
            yield return _sixth;
            yield return _seventh;
            yield return _eigth;
        }
    }

    public class Tuple<A, B, C, D, E, F, G, H, I> : Tuple<A, B, C, D, E, F, G, H>
    {
        protected I _ninth;
        public I Ninth
        {
            get { return _ninth; }
            set { _ninth = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D), default(E), default(F), default(G), default(H), default(I))
        {
        }

        public Tuple(A first, B second, C third, D fourth, E fifth, F sixth, G seventh, H eigth, I ninth)
            : base(first, second, third, fourth, fifth, sixth, seventh, eigth)
        {
            _ninth = ninth;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
            yield return _fifth;
            yield return _sixth;
            yield return _seventh;
            yield return _eigth;
            yield return _ninth;
        }
    }

    public class Tuple<A, B, C, D, E, F, G, H, I, J> : Tuple<A, B, C, D, E, F, G, H, I>
    {
        protected J _tenth;
        public J Tenth
        {
            get { return _tenth; }
            set { _tenth = value; }
        }

        public Tuple()
            : this(default(A), default(B), default(C), default(D), default(E), default(F), default(G), default(H), default(I), default(J))
        {
        }

        public Tuple(A first, B second, C third, D fourth, E fifth, F sixth, G seventh, H eigth, I ninth, J tenth)
            : base(first, second, third, fourth, fifth, sixth, seventh, eigth, ninth)
        {
            _tenth = tenth;
        }

        public override IEnumerator<object> GetEnumerator()
        {
            yield return _first;
            yield return _second;
            yield return _third;
            yield return _fourth;
            yield return _fifth;
            yield return _sixth;
            yield return _seventh;
            yield return _eigth;
            yield return _ninth;
            yield return _tenth;
        }
    }
}