// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.SlideShow;

/// <summary>
/// Test to validate that SlideShow works well if no pictures are returned by the webservice
/// </summary>
/// <TestSuite>
///   <Path>SlideShow\NoPictures.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.SlideShowBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.SlideShow.NoPicturesPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("SlideShow.NoPictures")]
public class SlideShow_NoPictures : AjaxControlToolkit.Testing.Client.SlideShow.SlideShow_Common
{
    [WebTestMethod]
    [WebTestFailureTag(Browsers.Opera, "Image source empty if no image is set")]
    public void ValidateNoPicture()
    {
        NoPicturesPage page = new NoPicturesPage();
        try
        {
            page.slideShowExtender1.AssertSlideUrl("/");
        }
        catch (WebTestingException)
        {
            page.slideShowExtender1.AssertSlideUrl("NoPictures.aspx");
        }
    }
}