// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.NumericUpDown;

/// <summary>
/// Validate that using a webservice with NumericUpDown works fine
/// </summary>
/// <TestSuite>
///   <Path>NumericUpDown\WebService.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.NumericUpDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.NumericUpDown.WebServicePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("NumericUpDown.WebService")]
public class NumericUpDown_WebService : AjaxControlToolkit.Testing.Client.NumericUpDown.NumericUpDown_Common
{
    /// <summary>
    /// Test that validates that value in a textbox extended by NumericUpDown can be 
    /// increased and decreased using the WebService support in NumericUpDown.
    /// </summary>
    [WebTestMethod]
    [WebTestTag("Smoke")]
    public void TestWebService()
    {
        WebServicePage page = new WebServicePage();

        // it starts with 500 in the textbox
        int currentValue = System.Int32.Parse(page.TextBox3.GetAttributes().Value);
        for (int i = currentValue; i < 550; i = currentValue)
        {
            page.NumericUpDownExtender3.ClickUp();
            Common.Wait(
                page, 3,
                delegate() 
                {
                    currentValue = System.Int32.Parse(page.TextBox3.GetAttributes().Value);
                    Assert.IsTrue(i < currentValue, "i: {0} currentValue: {1}", i, currentValue);
                    return true;
                });
        }

        for (int j = currentValue; j > 500; j = currentValue)
        {
            page.NumericUpDownExtender3.ClickDown();
            Common.Wait(
                page, 3,
                delegate()
                {
                    currentValue = System.Int32.Parse(page.TextBox3.GetAttributes().Value);
                    Assert.IsTrue(j > currentValue, "j: {0} currentValue: {1}", j, currentValue);
                    return true;
                });
        }
    }
}