// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.NumericUpDown;

/// <summary>
/// Ensure that NumericUpDown works when numeric values are provided
/// </summary>
/// <TestSuite>
///   <Path>NumericUpDown\ValidateNumericValue.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.NumericUpDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.NumericUpDown.ValidateNumericValuePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("NumericUpDown.ValidateNumericValue")]
public class NumericUpDown_ValidateNumericValue : AjaxControlToolkit.Testing.Client.NumericUpDown.NumericUpDown_Common
{
    /// <summary>
    /// Test that validates that a numeric updown extended textbox that contains numbers 
    /// can be updated using the up/down buttons to increase/decrease the numeric value 
    /// </summary>
    [WebTestMethod]
    public void ValidateNumericValues()
    {
        ValidateNumericValuePage page = new ValidateNumericValuePage();
        // it starts with the number 3 in the textbox.
        int currentValue = System.Int32.Parse(page.TextBox1.GetAttributes().Value);
        for (int i = currentValue + 1; i < 10; ++i)
        {
            page.NumericUpDownExtender1.ClickUp();
            Assert.AreEqual(page.TextBox1.GetAttributes().Value, i.ToString());
        }

        currentValue = int.Parse(page.TextBox1.GetAttributes().Value);
        for (int j = currentValue - 1; j > 3; j--)
        {
            page.NumericUpDownExtender1.ClickDown();
            Assert.AreEqual(page.TextBox1.GetAttributes().Value, j.ToString());
        }
    }
}