// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.FilteredTextBox;

/// <summary>
/// SampleWebSite scenario
/// </summary>
/// <TestSuite>
///   <Path>FilteredTextBox\Sample.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.FilteredTextBoxBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.FilteredTextBox.SamplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("FilteredTextBox.Sample")]
[WebTestTag("SampleWebSite")]
public class FilteredTextBox_Sample : AjaxControlToolkit.Testing.Client.FilteredTextBox.FilteredTextBox_Common
{
    public override IEnumerable<FilteredTextBoxBehavior> FilteredTextBoxes
    {
        get
        {
            SamplePage page = new SamplePage();
            yield return page.FilteredTextBoxExtender1;
            yield return page.FilteredTextBoxExtender2;
            yield return page.FilteredTextBoxExtender3;
            yield return page.FilteredTextBoxExtender4;
        }
    }
}