// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.DropDown;

/// <summary>
/// DropDown for Hyperlink
/// </summary>
/// <TestSuite>
///   <Path>DropDown\ForHyperlink.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.DropDownBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.DropDown.ForHyperlinkPage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("DropDown.ForHyperlink")]
public class DropDown_ForHyperlink : AjaxControlToolkit.Testing.Client.DropDown.DropDown_Common
{
    public override IEnumerable<DropDownBehavior> DropDownBehaviors
    {
        get
        {
            yield return new ForHyperlinkPage().DropDown;
        }
    }

    [WebTestMethod]
    public void ClickHyperLink()
    {
        ForHyperlinkPage page = new ForHyperlinkPage();
        page.DropDown.HoverBehavior.HoverOver();
        page.DropDown.Element.Click(true);
    }

    [WebTestMethod]
    public void ContextHyperLink()
    {
        ForHyperlinkPage page = new ForHyperlinkPage();
        page.DropDown.HoverBehavior.HoverOver(); 
        page.DropDown.Element.DispatchEvent(new HtmlEvent("ContextMenu"));
        page.DropDown.AssertHover();
    }
}
