// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.Web.Testing;

namespace AjaxControlToolkit.Testing.Client.DragPanel
{
    /// <summary>
    /// Common DragPanel tests
    /// </summary>
    /// <TestSuite>
    ///   <ComponentType>AjaxControlToolkit.Testing.Client.DragPanelBehavior</ComponentType>
    /// </TestSuite>
    [WebTestTag("DragPanel")]
    public abstract class DragPanel_Common
    {
        public abstract IEnumerable<DragPanelScenario> DragPanelScenarios
        {
            get;
        }

        [WebTestMethod]
        public void Common_InitialPosition()
        {
            foreach (DragPanelScenario dragPanelScenario in DragPanelScenarios)
            {
                Assert.AreEqual(dragPanelScenario.Start, dragPanelScenario.Behavior.Location.Value);
            }
        }

        [WebTestMethod]
        [WebTestTag("Smoke")]
        public void Common_Drag()
        {
            foreach (DragPanelScenario dragPanelScenario in DragPanelScenarios)
            {
                MoveDragPanel(dragPanelScenario.Behavior, dragPanelScenario.Start, new Point(100, 100));
            }
        }

        [WebTestMethod]
        public void Common_DragMultiple()
        {
            foreach (DragPanelScenario dragPanelScenario in DragPanelScenarios)
            {
                Point last = dragPanelScenario.Start;
                foreach (Point point in new Point[] { new Point(300, 300), new Point(100, 300), new Point(300, 100), new Point(0, 0), new Point(-10, -10) })
                {
                    MoveDragPanel(dragPanelScenario.Behavior, last, point);
                    last = point;
                }
            }
        }

        internal static void MoveDragPanel(DragPanelBehavior behavior, Point startLocation, Point endLocation)
        {
            behavior.Drag(startLocation, endLocation);
            behavior.Location.Invalidate();
            Assert.AreEqual(endLocation, behavior.Location.Value);
        }
    }
}