// (c) Copyright Microsoft Corporation.
// This source is subject to the Microsoft Public License.
// See http://www.microsoft.com/opensource/licenses.mspx#Ms-PL.
// All other rights reserved.

using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using Microsoft.Web.Testing;
using Microsoft.Web.Testing.UI;
using AjaxControlToolkit.Testing.Client;
using AjaxControlToolkit.Testing.Client.AlwaysVisibleControl;

/// <summary>
/// Basic AlwaysVisibleControl tests
/// </summary>
/// <TestSuite>
///   <Path>AlwaysVisibleControl\Simple.aspx</Path>
///   <ComponentType>AjaxControlToolkit.Testing.Client.AlwaysVisibleControlBehavior</ComponentType>
///   <WrapperType>AjaxControlToolkit.Testing.Client.AlwaysVisibleControl.SimplePage</WrapperType>
/// </TestSuite>
[WebTestClass]
[WebTestTag("AlwaysVisibleControl.Simple")]
public class AlwaysVisibleControl_Simple : AlwaysVisibleControl_Common
{
    public static readonly Unit InitialTop = 15;
    public static readonly Unit InitialLeft = 40;
    public static readonly int AnimationWaitDuration = 3;

    [WebTestMethod]
    public void InitialPosition()
    {
        SimplePage page = new SimplePage();
        page.AlwaysVisible.AssertPosition(InitialTop, InitialLeft);
    }

    [WebTestMethod]
    public void ScrollVertically()
    {
        SimplePage page = new SimplePage();
        page.AlwaysVisible.AssertPosition(InitialTop, InitialLeft);

        Common.ScrollIntoView(page.End);
        if (page.AlwaysVisible.RequiresAnimation.Value)
        {
            Common.Wait(page, AnimationWaitDuration, delegate() { page.AlwaysVisible.AssertHasMovedVertically(InitialTop); return true; });
        }

        Common.ScrollIntoView(page.Begin);
        if (page.AlwaysVisible.RequiresAnimation.Value)
        {
            Common.Wait(page, AnimationWaitDuration, delegate() { page.AlwaysVisible.AssertHasMovedVertically(0); return true; });
        }
    }

    [WebTestMethod]
    public void ScrollHorizontally()
    {
        SimplePage page = new SimplePage();
        page.AlwaysVisible.AssertPosition(InitialTop, InitialLeft);

        Common.ScrollIntoView(page.Right);
        if (page.AlwaysVisible.RequiresAnimation.Value)
        {
            Common.Wait(page, AnimationWaitDuration, delegate() { page.AlwaysVisible.AssertHasMovedHorizontally(InitialLeft); return true; });
        }
    }

    [WebTestMethod]
    public void RestoreAfterPostback()
    {
        SimplePage page = new SimplePage();
        page.AlwaysVisible.AssertPosition(InitialTop, InitialLeft);

        Common.ScrollIntoView(page.End);
        if (page.AlwaysVisible.RequiresAnimation.Value)
        {
            Common.Wait(page, AnimationWaitDuration, delegate() { page.AlwaysVisible.AssertHasMovedVertically(InitialTop); return true; });
        }

        page.Button.Click(true);
        page.Invalidate();

        page.AlwaysVisible.AssertPosition(InitialTop, InitialLeft);
    }

    [WebTestMethod]
    public void PositioningChanges()
    {
        SimplePage page = new SimplePage();
        page.AlwaysVisible.AssertPosition(InitialTop, InitialLeft);

        page.AlwaysVisible.Repositioned.Register();
        page.AlwaysVisible.HorizontalSide.Value = AjaxControlToolkit.HorizontalSide.Right;
        page.AlwaysVisible.VerticalSide.Value = AjaxControlToolkit.VerticalSide.Bottom;
        page.Synchronize();

        page.AlwaysVisible.Repositioned.Wait(3);
        page.AlwaysVisible.AssertHasMovedVertically(InitialTop);
        page.AlwaysVisible.AssertHasMovedHorizontally(InitialLeft);
    }
}