package com.apptl.chapter2.threads;

import android.os.Bundle;
import android.app.Activity;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Menu;
import android.widget.TextView;
import com.apptl.chapter2.R;

public class HandlerDemo extends Activity implements Handler.Callback {
    private Handler mHandler;
    private Handler mUiHandler;

    public static final int BACKGROUND_OPERATION = 10;
    public static final int MAIN_THREAD_OPERATION = 20;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        // Uruchomienie nowego wtku z Looper
        HandlerThread handlerThread = new HandlerThread("BackgroundThread");
        handlerThread.start();
        // Utworzenie nowego obiektu klasy Handler
        mHandler = new Handler(handlerThread.getLooper(), this);

        // Ten Handler bdzie dziaa w wtku gwnym
        mUiHandler = new Handler(getMainLooper(), this);
    }



    @Override
    protected void onDestroy() {
        super.onDestroy();
        // Zamknicie wtku z Looper
        mHandler.getLooper().quit();
    }

    @Override
    public boolean handleMessage(Message message) {
        // Przetwarzanie przychodzcych komunikatw...

        switch (message.what) {
            case BACKGROUND_OPERATION: // Wykonywanie operacji w tle
                performBackgroundOoperation(message.obj);
                break;
            case MAIN_THREAD_OPERATION: // Aktualizacja elementu UI
                ((TextView) findViewById(R.id.status_text)).setText((String) message.obj);
                findViewById(R.id.status_text).invalidate();
                break;
        }

        // Odzyskanie do uytku obiektu message
        message.recycle();
        return true;
    }

    private void performBackgroundOoperation(Object obj) {
        // Do zrobienia: jaka operacja w tle...
    }
}
